/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitFileUtils {
    private static final Logger LOG = Logger.getInstance((String)GitFileUtils.class.getName());

    private GitFileUtils() {
    }

    public static void delete(Project project, VirtualFile root, Collection<FilePath> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RM);
            handler.addParameters(additionalOptions);
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    public static void deleteFiles(Project project, VirtualFile root, Collection<VirtualFile> files, String ... additionalOptions) throws VcsException {
        for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RM);
            handler.addParameters(additionalOptions);
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    public static void deleteFiles(Project project, VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.deleteFiles(project, root, Arrays.asList(files), new String[0]);
    }

    public static void deleteFilesFromCache(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "deleteFilesFromCache"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "deleteFilesFromCache"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitFileUtils", "deleteFilesFromCache"));
        }
        GitFileUtils.deleteFiles(project, root, files, "--cached");
        GitFileUtils.updateUntrackedFilesHolderOnFileRemove(project, root, files);
    }

    public static void addFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "addFiles"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "addFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitFileUtils", "addFiles"));
        }
        GitFileUtils.addPaths(project, root, VcsFileUtil.chunkFiles((VirtualFile)root, files));
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, files);
    }

    private static void updateUntrackedFilesHolderOnFileAdd(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> addedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "updateUntrackedFilesHolderOnFileAdd"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "updateUntrackedFilesHolderOnFileAdd"));
        }
        if (addedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitFileUtils", "updateUntrackedFilesHolderOnFileAdd"));
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().remove(addedFiles);
    }

    private static void updateUntrackedFilesHolderOnFileRemove(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<VirtualFile> removedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "updateUntrackedFilesHolderOnFileRemove"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "updateUntrackedFilesHolderOnFileRemove"));
        }
        if (removedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitFileUtils", "updateUntrackedFilesHolderOnFileRemove"));
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root.getPresentableUrl());
            return;
        }
        repository.getUntrackedFilesHolder().add(removedFiles);
    }

    public static void addFiles(Project project, VirtualFile root, VirtualFile ... files) throws VcsException {
        GitFileUtils.addFiles(project, root, Arrays.asList(files));
    }

    public static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<FilePath> files) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "addPaths"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "addPaths"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitFileUtils", "addPaths"));
        }
        GitFileUtils.addPaths(project, root, VcsFileUtil.chunkPaths((VirtualFile)root, files));
        GitFileUtils.updateUntrackedFilesHolderOnFileAdd(project, root, GitFileUtils.getVirtualFilesFromFilePaths(files));
    }

    @NotNull
    private static Collection<VirtualFile> getVirtualFilesFromFilePaths(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "getVirtualFilesFromFilePaths"));
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(paths.size());
        for (FilePath path : paths) {
            VirtualFile file = path.getVirtualFile();
            if (file == null) continue;
            files.add(file);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitFileUtils", "getVirtualFilesFromFilePaths"));
        }
        return arrayList;
    }

    private static void addPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<List<String>> chunkedPaths) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "addPaths"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "addPaths"));
        }
        if (chunkedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitFileUtils", "addPaths"));
        }
        for (List<String> paths : chunkedPaths) {
            if ((paths = GitFileUtils.excludeIgnoredFiles(project, root, paths)).isEmpty()) continue;
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.ADD);
            handler.addParameters("--ignore-errors");
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    @NotNull
    private static List<String> excludeIgnoredFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> paths) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "excludeIgnoredFiles"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "excludeIgnoredFiles"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitFileUtils", "excludeIgnoredFiles"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.LS_FILES);
        handler.setSilent(true);
        handler.addParameters("--ignored", "--others", "--exclude-standard");
        handler.endOptions();
        handler.addParameters(paths);
        String output = handler.run();
        ArrayList<String> nonIgnoredFiles = new ArrayList<String>(paths.size());
        HashSet<String> ignoredPaths = new HashSet<String>(Arrays.asList(StringUtil.splitByLines((String)output)));
        for (String pathToCheck : paths) {
            if (ignoredPaths.contains(pathToCheck)) continue;
            nonIgnoredFiles.add(pathToCheck);
        }
        ArrayList<String> arrayList = nonIgnoredFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitFileUtils", "excludeIgnoredFiles"));
        }
        return arrayList;
    }

    public static byte[] getFileContent(Project project, VirtualFile root, String revisionOrBranch, String relativePath) throws VcsException {
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters(revisionOrBranch + ":" + relativePath);
        return h.run();
    }

    public static String stripFileProtocolPrefix(String path) {
        String FILE_PROTOCOL = "file://";
        if (path.startsWith("file://")) {
            return path.substring("file://".length());
        }
        return path;
    }

    public static boolean shouldIgnoreCaseChange(@NotNull String onePath, @NotNull String secondPath) {
        if (onePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "shouldIgnoreCaseChange"));
        }
        if (secondPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "shouldIgnoreCaseChange"));
        }
        return !SystemInfo.isFileSystemCaseSensitive && GitFileUtils.onlyCaseChanged(onePath, secondPath);
    }

    private static boolean onlyCaseChanged(@NotNull String one, @NotNull String second) {
        if (one == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitFileUtils", "onlyCaseChanged"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitFileUtils", "onlyCaseChanged"));
        }
        return one.compareToIgnoreCase(second) == 0;
    }
}

