/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.merge.MergeChangeCollector;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class GitUpdater {
    private static final Logger LOG = Logger.getInstance(GitUpdater.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final VirtualFile myRoot;
    @NotNull
    protected final Map<VirtualFile, GitBranchPair> myTrackedBranches;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final UpdatedFiles myUpdatedFiles;
    @NotNull
    protected final AbstractVcsHelper myVcsHelper;
    @NotNull
    protected final GitRepositoryManager myRepositoryManager;
    protected final GitVcs myVcs;
    protected GitRevisionNumber myBefore;

    protected GitUpdater(@NotNull Project project, @NotNull Git git, @NotNull VirtualFile root, @NotNull Map<VirtualFile, GitBranchPair> trackedBranches, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/update/GitUpdater", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/update/GitUpdater", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/update/GitUpdater", "<init>"));
        }
        if (trackedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/update/GitUpdater", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/update/GitUpdater", "<init>"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/update/GitUpdater", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myRoot = root;
        this.myTrackedBranches = trackedBranches;
        this.myProgressIndicator = progressIndicator;
        this.myUpdatedFiles = updatedFiles;
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = GitVcs.getInstance(project);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    @NotNull
    public static GitUpdater getUpdater(@NotNull Project project, @NotNull Git git, @NotNull Map<VirtualFile, GitBranchPair> trackedBranches, @NotNull VirtualFile root, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (trackedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/update/GitUpdater", "getUpdater"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/update/GitUpdater", "getUpdater"));
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        if (settings == null) {
            GitUpdater gitUpdater = GitUpdater.getDefaultUpdaterForBranch(project, git, root, trackedBranches, progressIndicator, updatedFiles);
            if (gitUpdater == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getUpdater"));
            }
            return gitUpdater;
        }
        switch (settings.getUpdateType()) {
            case REBASE: {
                GitRebaseUpdater gitRebaseUpdater = new GitRebaseUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles);
                if (gitRebaseUpdater == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getUpdater"));
                }
                return gitRebaseUpdater;
            }
            case MERGE: {
                GitMergeUpdater gitMergeUpdater = new GitMergeUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles);
                if (gitMergeUpdater == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getUpdater"));
                }
                return gitMergeUpdater;
            }
            case BRANCH_DEFAULT: {
                GitUpdater gitUpdater = GitUpdater.getDefaultUpdaterForBranch(project, git, root, trackedBranches, progressIndicator, updatedFiles);
                if (gitUpdater == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getUpdater"));
                }
                return gitUpdater;
            }
        }
        GitUpdater gitUpdater = GitUpdater.getDefaultUpdaterForBranch(project, git, root, trackedBranches, progressIndicator, updatedFiles);
        if (gitUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getUpdater"));
        }
        return gitUpdater;
    }

    @NotNull
    private static GitUpdater getDefaultUpdaterForBranch(@NotNull Project project, @NotNull Git git, @NotNull VirtualFile root, @NotNull Map<VirtualFile, GitBranchPair> trackedBranches, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        block10: {
            GitRebaseUpdater gitRebaseUpdater;
            block11: {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
                }
                if (git == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
                }
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
                }
                if (trackedBranches == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
                }
                if (progressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
                }
                if (updatedFiles == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
                }
                try {
                    GitLocalBranch branch = GitBranchUtil.getCurrentBranch(project, root);
                    boolean rebase = false;
                    if (branch != null) {
                        String rebaseValue = GitConfigUtil.getValue(project, root, "branch." + branch.getName() + ".rebase");
                        boolean bl = rebase = rebaseValue != null && rebaseValue.equalsIgnoreCase("true");
                    }
                    if (!rebase) break block10;
                    gitRebaseUpdater = new GitRebaseUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles);
                    if (gitRebaseUpdater != null) break block11;
                }
                catch (VcsException e) {
                    LOG.info("getDefaultUpdaterForBranch branch", (Throwable)e);
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
            }
            return gitRebaseUpdater;
        }
        GitMergeUpdater gitMergeUpdater = new GitMergeUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles);
        if (gitMergeUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "getDefaultUpdaterForBranch"));
        }
        return gitMergeUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitUpdateResult update() throws VcsException {
        this.markStart(this.myRoot);
        GitUpdateResult gitUpdateResult = this.doUpdate();
        GitUpdateResult gitUpdateResult2 = gitUpdateResult;
        if (gitUpdateResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "update"));
        }
        return gitUpdateResult2;
        finally {
            this.markEnd(this.myRoot);
        }
    }

    public abstract boolean isSaveNeeded();

    public boolean isUpdateNeeded() throws VcsException {
        GitBranchPair gitBranchPair = this.myTrackedBranches.get(this.myRoot);
        String currentBranch = gitBranchPair.getBranch().getName();
        GitRemoteBranch dest = gitBranchPair.getDest();
        assert (dest != null);
        String remoteBranch = dest.getName();
        if (!this.hasRemoteChanges(currentBranch, remoteBranch)) {
            LOG.info("isSaveNeeded No remote changes, save is not needed");
            return false;
        }
        return true;
    }

    protected abstract GitUpdateResult doUpdate();

    protected void markStart(VirtualFile root) throws VcsException {
        this.myBefore = GitRevisionNumber.resolve(this.myProject, root, "HEAD");
    }

    protected void markEnd(VirtualFile root) throws VcsException {
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, root, this.myBefore);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        collector.collect(this.myUpdatedFiles, exceptions);
        if (!exceptions.isEmpty()) {
            throw exceptions.get(0);
        }
    }

    protected boolean hasRemoteChanges(@NotNull String currentBranch, @NotNull String remoteBranch) throws VcsException {
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/update/GitUpdater", "hasRemoteChanges"));
        }
        if (remoteBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/update/GitUpdater", "hasRemoteChanges"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.REV_LIST);
        handler.setSilent(true);
        handler.addParameters("-1");
        handler.addParameters(currentBranch + ".." + remoteBranch);
        String output = handler.run();
        return output != null && !output.isEmpty();
    }

    @NotNull
    protected String makeProgressTitle(@NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/update/GitUpdater", "makeProgressTitle"));
        }
        String string = this.myRepositoryManager.moreThanOneRoot() ? String.format("%s %s...", operation, this.myRoot.getName()) : operation + "...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdater", "makeProgressTitle"));
        }
        return string;
    }
}

