/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.TabbedPaneImpl;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDiffPanel;
import git4idea.ui.branch.GitCompareBranchesLogPanel;
import git4idea.util.GitCommitCompareInfo;
import icons.Git4ideaIcons;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitCompareBranchesDialog
extends DialogWrapper {
    private final Project myProject;
    private final String myBranchName;
    private final String myCurrentBranchName;
    private final GitCommitCompareInfo myCompareInfo;
    private final GitRepository myInitialRepo;
    private JPanel myLogPanel;

    public GitCompareBranchesDialog(@NotNull Project project, @NotNull String branchName, @NotNull String currentBranchName, @NotNull GitCommitCompareInfo compareInfo, @NotNull GitRepository initialRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (currentBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (compareInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        if (initialRepo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/ui/branch/GitCompareBranchesDialog", "<init>"));
        }
        super(project, false);
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myProject = project;
        this.myBranchName = branchName;
        this.myInitialRepo = initialRepo;
        String rootString = compareInfo.getRepositories().size() == 1 && GitUtil.getRepositoryManager(this.myProject).moreThanOneRoot() ? " in root " + DvcsUtil.getShortRepositoryName((Repository)initialRepo) : "";
        this.setTitle(String.format("Comparing %s with %s%s", currentBranchName, branchName, rootString));
        this.setModal(false);
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myLogPanel = new GitCompareBranchesLogPanel(this.myProject, this.myBranchName, this.myCurrentBranchName, this.myCompareInfo, this.myInitialRepo);
        GitCompareBranchesDiffPanel diffPanel = new GitCompareBranchesDiffPanel(this.myProject, this.myBranchName, this.myCurrentBranchName, this.myCompareInfo);
        TabbedPaneImpl tabbedPane = new TabbedPaneImpl(1);
        tabbedPane.addTab("Log", Git4ideaIcons.Branch, (Component)this.myLogPanel);
        tabbedPane.addTab("Diff", AllIcons.Actions.Diff, (Component)diffPanel);
        tabbedPane.setKeyboardNavigation(TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS);
        return tabbedPane;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitCompareBranchesDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getDimensionServiceKey() {
        return GitCompareBranchesDialog.class.getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLogPanel;
    }
}

