/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.popup.list.ListPopupImpl;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitBranchSyncSetting;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopup {
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;
    private final GitVcsSettings myVcsSettings;
    private final GitVcs myVcs;
    private final GitMultiRootBranchConfig myMultiRootBranchConfig;
    private final GitRepository myCurrentRepository;
    private final ListPopupImpl myPopup;

    ListPopup asListPopup() {
        return this.myPopup;
    }

    static GitBranchPopup getInstance(@NotNull Project project, @NotNull GitRepository currentRepository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/ui/branch/GitBranchPopup", "getInstance"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/ui/branch/GitBranchPopup", "getInstance"));
        }
        return new GitBranchPopup(project, currentRepository);
    }

    private GitBranchPopup(@NotNull Project project, @NotNull GitRepository currentRepository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        this.myProject = project;
        this.myCurrentRepository = currentRepository;
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
        this.myVcs = GitVcs.getInstance(project);
        this.myVcsSettings = GitVcsSettings.getInstance(this.myProject);
        this.myMultiRootBranchConfig = new GitMultiRootBranchConfig(this.myRepositoryManager.getRepositories());
        String title = this.createPopupTitle(currentRepository);
        Condition<AnAction> preselectActionCondition = new Condition<AnAction>(){

            public boolean value(AnAction action) {
                if (action instanceof GitBranchPopupActions.LocalBranchActions) {
                    GitBranchPopupActions.LocalBranchActions branchAction = (GitBranchPopupActions.LocalBranchActions)action;
                    String branchName = branchAction.getBranchName();
                    List<GitRepository> repositories = branchAction.getRepositories();
                    String recentBranch = repositories.size() == 1 ? GitBranchPopup.this.myVcsSettings.getRecentBranchesByRepository().get(repositories.iterator().next().getRoot().getPath()) : GitBranchPopup.this.myVcsSettings.getRecentCommonBranch();
                    if (recentBranch != null && recentBranch.equals(branchName)) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.myPopup = new BranchActionGroupPopup(title, project, (Condition)preselectActionCondition, this.createActions());
        this.initBranchSyncPolicyIfNotInitialized();
        this.setCurrentBranchInfo();
        this.warnThatBranchesDivergedIfNeeded();
    }

    private void initBranchSyncPolicyIfNotInitialized() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == GitBranchSyncSetting.NOT_DECIDED) {
            if (!this.myMultiRootBranchConfig.diverged()) {
                this.notifyAboutSyncedBranches();
                this.myVcsSettings.setSyncSetting(GitBranchSyncSetting.SYNC);
            } else {
                this.myVcsSettings.setSyncSetting(GitBranchSyncSetting.DONT);
            }
        }
    }

    @NotNull
    private String createPopupTitle(@NotNull GitRepository currentRepository) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/ui/branch/GitBranchPopup", "createPopupTitle"));
        }
        String title = "Git Branches";
        if (this.myRepositoryManager.moreThanOneRoot() && (this.myMultiRootBranchConfig.diverged() || this.myVcsSettings.getSyncSetting() == GitBranchSyncSetting.DONT)) {
            title = title + " in " + DvcsUtil.getShortRepositoryName((Repository)currentRepository);
        }
        String string = title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopup", "createPopupTitle"));
        }
        return string;
    }

    private void setCurrentBranchInfo() {
        String currentBranchText = "Current branch";
        currentBranchText = this.myRepositoryManager.moreThanOneRoot() ? (this.myMultiRootBranchConfig.diverged() ? currentBranchText + " in " + DvcsUtil.getShortRepositoryName((Repository)this.myCurrentRepository) + ": " + GitBranchUtil.getDisplayableBranchText(this.myCurrentRepository) : currentBranchText + ": " + this.myMultiRootBranchConfig.getCurrentBranch()) : currentBranchText + ": " + GitBranchUtil.getDisplayableBranchText(this.myCurrentRepository);
        this.myPopup.setAdText(currentBranchText, 0);
    }

    private void notifyAboutSyncedBranches() {
        VcsNotifier.getInstance((Project)this.myProject).notifyImportantInfo("Synchronous branch control enabled", "You have several Git roots in the project and they all are checked out at the same branch. We've enabled synchronous branch control for the project. <br/>If you wish to control branches in different roots separately, you may <a href='settings'>disable</a> the setting.", new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/ui/branch/GitBranchPopup$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/ui/branch/GitBranchPopup$2", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(GitBranchPopup.this.myProject, GitBranchPopup.this.myVcs.getConfigurable().getDisplayName());
                    if (GitBranchPopup.this.myVcsSettings.getSyncSetting() == GitBranchSyncSetting.DONT) {
                        notification.expire();
                    }
                }
            }
        });
    }

    private ActionGroup createActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        GitRepositoryManager repositoryManager = this.myRepositoryManager;
        if (repositoryManager.moreThanOneRoot()) {
            if (!this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl()) {
                this.fillWithCommonRepositoryActions(popupGroup, repositoryManager);
            } else {
                this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
            }
        } else {
            this.fillPopupWithCurrentRepositoryActions(popupGroup, null);
        }
        popupGroup.addSeparator();
        return popupGroup;
    }

    private boolean userWantsSyncControl() {
        return this.myVcsSettings.getSyncSetting() != GitBranchSyncSetting.DONT;
    }

    private void fillWithCommonRepositoryActions(DefaultActionGroup popupGroup, GitRepositoryManager repositoryManager) {
        List repositories = repositoryManager.getRepositories();
        String currentBranch = this.myMultiRootBranchConfig.getCurrentBranch();
        assert (currentBranch != null) : "Current branch can't be null if branches have not diverged";
        popupGroup.add((AnAction)new GitBranchPopupActions.GitNewBranchAction(this.myProject, repositories));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator("Common Local Branches");
        for (String branch : this.myMultiRootBranchConfig.getLocalBranches()) {
            if (branch.equals(currentBranch)) continue;
            popupGroup.add((AnAction)new GitBranchPopupActions.LocalBranchActions(this.myProject, repositories, branch, this.myCurrentRepository));
        }
        popupGroup.addSeparator("Common Remote Branches");
        for (String branch : this.myMultiRootBranchConfig.getRemoteBranches()) {
            popupGroup.add((AnAction)new GitBranchPopupActions.RemoteBranchActions(this.myProject, repositories, branch, this.myCurrentRepository));
        }
    }

    private void warnThatBranchesDivergedIfNeeded() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl()) {
            this.myPopup.setWarning("Branches have diverged");
        }
    }

    private DefaultActionGroup createRepositoriesActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addSeparator("Repositories");
        for (GitRepository repository : this.myRepositoryManager.getRepositories()) {
            popupGroup.add((AnAction)new RootAction((Repository)repository, (Repository)(this.highlightCurrentRepo() ? this.myCurrentRepository : null), new GitBranchPopupActions(repository.getProject(), repository).createActions(null), GitBranchUtil.getDisplayableBranchText(repository)));
        }
        return popupGroup;
    }

    private boolean highlightCurrentRepo() {
        return !this.userWantsSyncControl() || this.myMultiRootBranchConfig.diverged();
    }

    private void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup popupGroup, @Nullable DefaultActionGroup actions) {
        if (popupGroup == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/ui/branch/GitBranchPopup", "fillPopupWithCurrentRepositoryActions"));
        }
        popupGroup.addAll(new GitBranchPopupActions(this.myCurrentRepository.getProject(), this.myCurrentRepository).createActions(actions));
    }
}

