/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.continuation.ContinuationContext;
import git4idea.GitPlatformFacade;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitShelveChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitChangesSaver.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final GitPlatformFacade myPlatformFacade;
    @NotNull
    protected final ChangeListManagerEx myChangeManager;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final String myStashMessage;
    protected GitConflictResolver.Params myParams;

    public abstract void refresh();

    public static GitChangesSaver getSaver(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/stash/GitChangesSaver", "getSaver"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/stash/GitChangesSaver", "getSaver"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/stash/GitChangesSaver", "getSaver"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/stash/GitChangesSaver", "getSaver"));
        }
        if (stashMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/stash/GitChangesSaver", "getSaver"));
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        if (settings == null) {
            return GitChangesSaver.getDefaultSaver(project, platformFacade, git, progressIndicator, stashMessage);
        }
        switch (settings.updateChangesPolicy()) {
            case STASH: {
                return new GitStashChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
            }
            case SHELVE: {
                return new GitShelveChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
            }
        }
        return GitChangesSaver.getDefaultSaver(project, platformFacade, git, progressIndicator, stashMessage);
    }

    private static GitChangesSaver getDefaultSaver(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/stash/GitChangesSaver", "getDefaultSaver"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/stash/GitChangesSaver", "getDefaultSaver"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/stash/GitChangesSaver", "getDefaultSaver"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/stash/GitChangesSaver", "getDefaultSaver"));
        }
        if (stashMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/stash/GitChangesSaver", "getDefaultSaver"));
        }
        return new GitStashChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
    }

    protected GitChangesSaver(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull String stashMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/stash/GitChangesSaver", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/stash/GitChangesSaver", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/stash/GitChangesSaver", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/stash/GitChangesSaver", "<init>"));
        }
        if (stashMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/stash/GitChangesSaver", "<init>"));
        }
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
        this.myGit = git;
        this.myProgressIndicator = indicator;
        this.myStashMessage = stashMessage;
        this.myChangeManager = platformFacade.getChangeListManager(project);
    }

    public void saveLocalChanges(@Nullable Collection<VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null || rootsToSave.isEmpty()) {
            return;
        }
        this.save(rootsToSave);
    }

    public void restoreLocalChanges(ContinuationContext context) {
        this.load(context);
    }

    public void notifyLocalChangesAreNotRestored() {
        if (this.wereChangesSaved()) {
            LOG.info("Update is incomplete, changes are not restored");
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Local changes were not restored", "Before update your uncommitted changes were saved to <a href='saver'>" + this.getSaverName() + "</a>.<br/>" + "Update is not complete, you have unresolved merges in your working tree<br/>" + "Resolve conflicts, complete update and restore changes manually.", (NotificationListener)new ShowSavedChangesNotificationListener());
        }
    }

    public void setConflictResolverParams(GitConflictResolver.Params params) {
        this.myParams = params;
    }

    protected abstract void save(Collection<VirtualFile> var1) throws VcsException;

    protected abstract void load(ContinuationContext var1);

    protected abstract boolean wereChangesSaved();

    public abstract String getSaverName();

    protected abstract void showSavedChanges();

    @NotNull
    protected static String getConflictRightPanelTitle() {
        if ("Changes from remote" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/stash/GitChangesSaver", "getConflictRightPanelTitle"));
        }
        return "Changes from remote";
    }

    @NotNull
    protected static String getConflictLeftPanelTitle() {
        if ("Your uncommitted changes" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/stash/GitChangesSaver", "getConflictLeftPanelTitle"));
        }
        return "Your uncommitted changes";
    }

    protected class ShowSavedChangesNotificationListener
    implements NotificationListener {
        protected ShowSavedChangesNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/stash/GitChangesSaver$ShowSavedChangesNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/stash/GitChangesSaver$ShowSavedChangesNotificationListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("saver")) {
                GitChangesSaver.this.showSavedChanges();
            }
        }
    }
}

