/*
 * Decompiled with CFR 0.152.
 */
package git4idea.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.roots.VcsIntegrationEnabler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import org.jetbrains.annotations.NotNull;

public class GitIntegrationEnabler
extends VcsIntegrationEnabler<GitVcs> {
    @NotNull
    private final Git myGit;
    private static final Logger LOG = Logger.getInstance(GitIntegrationEnabler.class);

    public GitIntegrationEnabler(@NotNull GitVcs vcs, @NotNull Git git) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/roots/GitIntegrationEnabler", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/roots/GitIntegrationEnabler", "<init>"));
        }
        super((AbstractVcs)vcs);
        this.myGit = git;
    }

    protected boolean initOrNotifyError(@NotNull VirtualFile projectDir) {
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/roots/GitIntegrationEnabler", "initOrNotifyError"));
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
        GitCommandResult result = this.myGit.init(this.myProject, projectDir, new GitLineHandlerListener[0]);
        if (result.success()) {
            GitIntegrationEnabler.refreshGitDir(projectDir);
            vcsNotifier.notifySuccess("Created Git repository in " + projectDir.getPresentableUrl());
            return true;
        }
        if (((GitVcs)this.myVcs).getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
            vcsNotifier.notifyError("Couldn't git init " + projectDir.getPresentableUrl(), result.getErrorOutputAsHtmlString());
            LOG.info(result.getErrorOutputAsHtmlString());
        }
        return false;
    }

    private static void refreshGitDir(final VirtualFile projectDir) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        LocalFileSystem.getInstance().refreshAndFindFileByPath(projectDir.getPath() + "/" + ".git");
                    }
                });
            }
        });
    }
}

