/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.util.GitFileUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitRepositoryUpdater
implements Disposable,
BulkFileListener {
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final MessageBusConnection myMessageBusConnection;
    @NotNull
    private final QueueProcessor<Object> myUpdateQueue;
    @NotNull
    private final Object DUMMY_UPDATE_OBJECT;
    @Nullable
    private final VirtualFile myRemotesDir;
    @Nullable
    private final VirtualFile myHeadsDir;
    @Nullable
    private final LocalFileSystem.WatchRequest myWatchRequest;

    GitRepositoryUpdater(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryUpdater", "<init>"));
        }
        this.DUMMY_UPDATE_OBJECT = new Object();
        VirtualFile gitDir = repository.getGitDir();
        this.myWatchRequest = LocalFileSystem.getInstance().addRootToWatch(gitDir.getPath(), true);
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(gitDir);
        RepositoryUtil.visitVcsDirVfs((VirtualFile)gitDir, GitRepositoryFiles.getSubDirRelativePaths());
        this.myHeadsDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getRefsHeadsPath());
        this.myRemotesDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getRefsRemotesPath());
        Project project = repository.getProject();
        this.myUpdateQueue = new QueueProcessor((Consumer)new RepositoryUtil.Updater((Repository)repository), project.getDisposed());
        if (!project.isDisposed()) {
            this.myMessageBusConnection = project.getMessageBus().connect();
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        } else {
            this.myMessageBusConnection = null;
        }
    }

    public void dispose() {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myWatchRequest);
        }
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryUpdater", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryUpdater", "after"));
        }
        boolean configChanged = false;
        boolean headChanged = false;
        boolean branchFileChanged = false;
        boolean packedRefsChanged = false;
        boolean rebaseFileChanged = false;
        boolean mergeFileChanged = false;
        for (VFileEvent vFileEvent : events) {
            String filePath = vFileEvent.getPath();
            if (filePath == null) continue;
            if (this.myRepositoryFiles.isConfigFile(filePath = GitFileUtils.stripFileProtocolPrefix(filePath))) {
                configChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isHeadFile(filePath)) {
                headChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBranchFile(filePath)) {
                branchFileChanged = true;
                RepositoryUtil.visitAllChildrenRecursively((VirtualFile)this.myHeadsDir);
                continue;
            }
            if (this.myRepositoryFiles.isRemoteBranchFile(filePath)) {
                branchFileChanged = true;
                RepositoryUtil.visitAllChildrenRecursively((VirtualFile)this.myRemotesDir);
                continue;
            }
            if (this.myRepositoryFiles.isPackedRefs(filePath)) {
                packedRefsChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                rebaseFileChanged = true;
                continue;
            }
            if (!this.myRepositoryFiles.isMergeFile(filePath)) continue;
            mergeFileChanged = true;
        }
        if (headChanged || configChanged || branchFileChanged || packedRefsChanged || rebaseFileChanged || mergeFileChanged) {
            this.myUpdateQueue.add(this.DUMMY_UPDATE_OBJECT);
        }
    }
}

