/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRemote;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    private static Pattern BRANCH_PATTERN = Pattern.compile("ref: refs/heads/(\\S+)");
    private static Pattern BRANCH_WEAK_PATTERN = Pattern.compile(" *(ref:)? */?refs/heads/(\\S+)");
    private static Pattern COMMIT_PATTERN = Pattern.compile("[0-9a-fA-F]+");
    @NonNls
    private static final String REFS_HEADS_PREFIX = "refs/heads/";
    @NonNls
    private static final String REFS_REMOTES_PREFIX = "refs/remotes/";
    @NotNull
    private final File myGitDir;
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;

    GitRepositoryReader(@NotNull File gitDir) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "<init>"));
        }
        this.myGitDir = gitDir;
        RepositoryUtil.assertFileExists((File)this.myGitDir, (String)(".git directory not found in " + gitDir));
        this.myHeadFile = new File(this.myGitDir, "HEAD");
        RepositoryUtil.assertFileExists((File)this.myHeadFile, (String)(".git/HEAD file not found in " + gitDir));
        this.myRefsHeadsDir = new File(new File(this.myGitDir, "refs"), "heads");
        this.myRefsRemotesDir = new File(new File(this.myGitDir, "refs"), "remotes");
        this.myPackedRefsFile = new File(this.myGitDir, "packed-refs");
    }

    @Nullable
    private static Hash createHash(@Nullable String hash) {
        try {
            return hash == null ? GitBranch.DUMMY_HASH : HashImpl.build((String)hash);
        }
        catch (Throwable t) {
            LOG.info(t);
            return null;
        }
    }

    @NotNull
    public Repository.State readState() {
        if (this.isMergeInProgress()) {
            Repository.State state = Repository.State.MERGING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
            }
            return state;
        }
        if (this.isRebaseInProgress()) {
            Repository.State state = Repository.State.REBASING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
            }
            return state;
        }
        Head head = this.readHead();
        if (!head.isBranch) {
            Repository.State state = Repository.State.DETACHED;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
            }
            return state;
        }
        Repository.State state = Repository.State.NORMAL;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
        }
        return state;
    }

    @Nullable
    String readCurrentRevision() {
        Head head = this.readHead();
        if (!head.isBranch) {
            return head.ref;
        }
        File branchFile = null;
        for (Map.Entry<String, File> entry : this.readLocalBranches().entrySet()) {
            if (!entry.getKey().equals(head.ref)) continue;
            branchFile = entry.getValue();
        }
        if (branchFile != null) {
            return GitRepositoryReader.readBranchFile(branchFile);
        }
        return this.findBranchRevisionInPackedRefs(head.ref);
    }

    @Nullable
    GitLocalBranch readCurrentBranch() {
        Head head = this.readHead();
        if (head.isBranch) {
            String branchName = head.ref;
            String hash = this.readCurrentRevision();
            Hash h = GitRepositoryReader.createHash(hash);
            if (h == null) {
                return null;
            }
            return new GitLocalBranch(branchName, h);
        }
        if (this.isRebaseInProgress()) {
            GitLocalBranch branch = this.readRebaseBranch("rebase-apply");
            if (branch == null) {
                branch = this.readRebaseBranch("rebase-merge");
            }
            return branch;
        }
        return null;
    }

    @Nullable
    private GitLocalBranch readRebaseBranch(@NonNls String rebaseDirName) {
        File rebaseDir = new File(this.myGitDir, rebaseDirName);
        if (!rebaseDir.exists()) {
            return null;
        }
        File headName = new File(rebaseDir, "head-name");
        if (!headName.exists()) {
            return null;
        }
        String branchName = RepositoryUtil.tryLoadFile((File)headName);
        File branchFile = this.findBranchFile(branchName);
        if (!branchFile.exists()) {
            return null;
        }
        Hash hash = GitRepositoryReader.createHash(GitRepositoryReader.readBranchFile(branchFile));
        if (hash == null) {
            return null;
        }
        if (branchName.startsWith(REFS_HEADS_PREFIX)) {
            branchName = branchName.substring(REFS_HEADS_PREFIX.length());
        }
        return new GitLocalBranch(branchName, hash);
    }

    @NotNull
    private File findBranchFile(@NotNull String branchName) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "findBranchFile"));
        }
        File file = new File(this.myGitDir.getPath() + File.separator + branchName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "findBranchFile"));
        }
        return file;
    }

    private boolean isMergeInProgress() {
        File mergeHead = new File(this.myGitDir, "MERGE_HEAD");
        return mergeHead.exists();
    }

    private boolean isRebaseInProgress() {
        File f = new File(this.myGitDir, "rebase-apply");
        if (f.exists()) {
            return true;
        }
        f = new File(this.myGitDir, "rebase-merge");
        return f.exists();
    }

    @Nullable
    private String findBranchRevisionInPackedRefs(final String ref) {
        if (!this.myPackedRefsFile.exists()) {
            return null;
        }
        final AtomicReference hashRef = new AtomicReference();
        this.readPackedRefsFile(new PackedRefsLineResultHandler(){

            @Override
            public void handleResult(String hash, String branchName) {
                if (hash == null || branchName == null) {
                    return;
                }
                if (branchName.endsWith(ref)) {
                    hashRef.set(GitRepositoryReader.shortBuffer(hash));
                    this.stop();
                }
            }
        });
        if (hashRef.get() != null) {
            return (String)hashRef.get();
        }
        return null;
    }

    private void readPackedRefsFile(final @NotNull PackedRefsLineResultHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "readPackedRefsFile"));
        }
        RepositoryUtil.tryOrThrow((Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(GitRepositoryReader.this.myPackedRefsFile));
                    while ((line = reader.readLine()) != null) {
                        GitRepositoryReader.parsePackedRefsLine(line, handler);
                        if (!handler.stopped()) continue;
                        String string = null;
                        return string;
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                return null;
            }
        }, (File)this.myPackedRefsFile);
    }

    private Map<String, File> readLocalBranches() {
        final HashMap<String, File> branches = new HashMap<String, File>();
        if (!this.myRefsHeadsDir.exists()) {
            return branches;
        }
        FileUtil.processFilesRecursively((File)this.myRefsHeadsDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String relativePath;
                if (!file.isDirectory() && (relativePath = FileUtil.getRelativePath((File)GitRepositoryReader.this.myRefsHeadsDir, (File)file)) != null) {
                    branches.put(FileUtil.toSystemIndependentName((String)relativePath), file);
                }
                return true;
            }
        });
        return branches;
    }

    GitBranchesCollection readBranches(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "readBranches"));
        }
        Set<GitLocalBranch> localBranches = this.readUnpackedLocalBranches();
        Set<GitRemoteBranch> remoteBranches = this.readUnpackedRemoteBranches(remotes);
        GitBranchesCollection packedBranches = this.readPackedBranches(remotes);
        localBranches.addAll(packedBranches.getLocalBranches());
        remoteBranches.addAll(packedBranches.getRemoteBranches());
        return new GitBranchesCollection(localBranches, remoteBranches);
    }

    @NotNull
    private Set<GitLocalBranch> readUnpackedLocalBranches() {
        HashSet<GitLocalBranch> branches = new HashSet<GitLocalBranch>();
        for (Map.Entry<String, File> entry : this.readLocalBranches().entrySet()) {
            String branchName = entry.getKey();
            File branchFile = entry.getValue();
            String hash = GitRepositoryReader.loadHashFromBranchFile(branchFile);
            Hash h = GitRepositoryReader.createHash(hash);
            if (h == null) continue;
            branches.add(new GitLocalBranch(branchName, h));
        }
        HashSet<GitLocalBranch> hashSet = branches;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readUnpackedLocalBranches"));
        }
        return hashSet;
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "loadHashFromBranchFile"));
        }
        try {
            return RepositoryUtil.tryLoadFile((File)branchFile);
        }
        catch (RepoStateException e) {
            LOG.error("Couldn't read " + branchFile, (Throwable)e);
            return null;
        }
    }

    @NotNull
    private Set<GitRemoteBranch> readUnpackedRemoteBranches(final @NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "readUnpackedRemoteBranches"));
        }
        final HashSet<GitRemoteBranch> branches = new HashSet<GitRemoteBranch>();
        if (!this.myRefsRemotesDir.exists()) {
            HashSet<GitRemoteBranch> hashSet = branches;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readUnpackedRemoteBranches"));
            }
            return hashSet;
        }
        FileUtil.processFilesRecursively((File)this.myRefsRemotesDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String relativePath;
                if (!file.isDirectory() && !file.getName().equalsIgnoreCase("HEAD") && (relativePath = FileUtil.getRelativePath((File)GitRepositoryReader.this.myGitDir, (File)file)) != null) {
                    GitRemoteBranch remoteBranch;
                    String branchName = FileUtil.toSystemIndependentName((String)relativePath);
                    String hash = GitRepositoryReader.loadHashFromBranchFile(file);
                    Hash h = GitRepositoryReader.createHash(hash);
                    if (h != null && (remoteBranch = GitBranchUtil.parseRemoteBranch(branchName, h, remotes)) != null) {
                        branches.add(remoteBranch);
                    }
                }
                return true;
            }
        });
        HashSet<GitRemoteBranch> hashSet = branches;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readUnpackedRemoteBranches"));
        }
        return hashSet;
    }

    @NotNull
    private GitBranchesCollection readPackedBranches(final @NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
        }
        final HashSet<GitLocalBranch> localBranches = new HashSet<GitLocalBranch>();
        final HashSet<GitRemoteBranch> remoteBranches = new HashSet<GitRemoteBranch>();
        if (!this.myPackedRefsFile.exists()) {
            GitBranchesCollection gitBranchesCollection = GitBranchesCollection.EMPTY;
            if (gitBranchesCollection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
            }
            return gitBranchesCollection;
        }
        this.readPackedRefsFile(new PackedRefsLineResultHandler(){

            @Override
            public void handleResult(@Nullable String hashString, @Nullable String branchName) {
                GitRemoteBranch remoteBranch;
                if (hashString == null || branchName == null) {
                    return;
                }
                Hash hash = GitRepositoryReader.createHash(hashString = GitRepositoryReader.shortBuffer(hashString));
                if (hash == null) {
                    return;
                }
                if (branchName.startsWith(GitRepositoryReader.REFS_HEADS_PREFIX)) {
                    localBranches.add(new GitLocalBranch(branchName, hash));
                } else if (branchName.startsWith(GitRepositoryReader.REFS_REMOTES_PREFIX) && (remoteBranch = GitBranchUtil.parseRemoteBranch(branchName, hash, remotes)) != null) {
                    remoteBranches.add(remoteBranch);
                }
            }
        });
        GitBranchesCollection gitBranchesCollection = new GitBranchesCollection(localBranches, remoteBranches);
        if (gitBranchesCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
        }
        return gitBranchesCollection;
    }

    @NotNull
    private static String readBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "readBranchFile"));
        }
        String string = RepositoryUtil.tryLoadFile((File)branchFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readBranchFile"));
        }
        return string;
    }

    @NotNull
    private Head readHead() {
        String headContent = RepositoryUtil.tryLoadFile((File)this.myHeadFile);
        Matcher matcher = BRANCH_PATTERN.matcher(headContent);
        if (matcher.matches()) {
            Head head = new Head(true, matcher.group(1));
            if (head == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return head;
        }
        if (COMMIT_PATTERN.matcher(headContent).matches()) {
            Head head = new Head(false, headContent);
            if (head == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return head;
        }
        matcher = BRANCH_WEAK_PATTERN.matcher(headContent);
        if (matcher.matches()) {
            LOG.info(".git/HEAD has not standard format: [" + headContent + "]. We've parsed branch [" + matcher.group(1) + "]");
            Head head = new Head(true, matcher.group(1));
            if (head == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return head;
        }
        throw new RepoStateException("Invalid format of the .git/HEAD file: \n" + headContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parsePackedRefsLine(@NotNull String line, @NotNull PackedRefsLineResultHandler resultHandler) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryReader", "parsePackedRefsLine"));
        }
        if (resultHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/repo/GitRepositoryReader", "parsePackedRefsLine"));
        }
        try {
            int i;
            char firstChar;
            line = line.trim();
            char c = firstChar = line.isEmpty() ? (char)'\u0000' : line.charAt(0);
            if (firstChar == '#') {
                return;
            }
            if (firstChar == '^') {
                return;
            }
            String hash = null;
            for (i = 0; i < line.length(); ++i) {
                char c2 = line.charAt(i);
                if (Character.isLetterOrDigit(c2)) continue;
                hash = line.substring(0, i);
                break;
            }
            String branch = null;
            int start = i;
            if (hash != null && start < line.length() && line.charAt(start++) == ' ') {
                char c3;
                for (i = start; i < line.length() && !Character.isWhitespace(c3 = line.charAt(i)); ++i) {
                }
                branch = line.substring(start, i);
            }
            if (hash != null && branch != null) {
                resultHandler.handleResult(hash.trim(), branch);
            } else {
                LOG.info("Ignoring invalid packed-refs line: [" + line + "]");
            }
        }
        finally {
            resultHandler.handleResult(null, null);
        }
    }

    @NotNull
    private static String shortBuffer(String raw) {
        String string = new String(raw);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "shortBuffer"));
        }
        return string;
    }

    private static class Head {
        @NotNull
        private final String ref;
        private final boolean isBranch;

        Head(boolean branch, @NotNull String ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/repo/GitRepositoryReader$Head", "<init>"));
            }
            this.isBranch = branch;
            this.ref = ref;
        }
    }

    private static abstract class PackedRefsLineResultHandler {
        private boolean myStopped;

        private PackedRefsLineResultHandler() {
        }

        abstract void handleResult(@Nullable String var1, @Nullable String var2);

        final void stop() {
            this.myStopped = true;
        }

        final boolean stopped() {
            return this.myStopped;
        }
    }
}

