/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryImpl;
import org.jetbrains.annotations.NotNull;

public class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    @NotNull
    private final GitPlatformFacade myPlatformFacade;

    public GitRepositoryManager(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        super(project, vcsManager, platformFacade.getVcs(project), ".git");
        this.myPlatformFacade = platformFacade;
    }

    @NotNull
    protected GitRepository createRepository(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryManager", "createRepository"));
        }
        GitRepository gitRepository = GitRepositoryImpl.getFullInstance(root, this.myProject, this.myPlatformFacade, (Disposable)this);
        if (gitRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryManager", "createRepository"));
        }
        return gitRepository;
    }
}

