/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitRemote;
import org.jetbrains.annotations.NotNull;

public class GitBranchTrackInfo {
    @NotNull
    private final GitLocalBranch myLocalBranch;
    @NotNull
    private final GitRemoteBranch myRemoteBranch;
    private final boolean myMerge;

    public GitBranchTrackInfo(@NotNull GitLocalBranch localBranch, @NotNull GitRemoteBranch remoteBranch, boolean merge) {
        if (localBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitBranchTrackInfo", "<init>"));
        }
        if (remoteBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/repo/GitBranchTrackInfo", "<init>"));
        }
        this.myLocalBranch = localBranch;
        this.myRemoteBranch = remoteBranch;
        this.myMerge = merge;
    }

    @NotNull
    public GitLocalBranch getLocalBranch() {
        GitLocalBranch gitLocalBranch = this.myLocalBranch;
        if (gitLocalBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitBranchTrackInfo", "getLocalBranch"));
        }
        return gitLocalBranch;
    }

    @NotNull
    public GitRemote getRemote() {
        GitRemote gitRemote = this.myRemoteBranch.getRemote();
        if (gitRemote == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitBranchTrackInfo", "getRemote"));
        }
        return gitRemote;
    }

    @NotNull
    public GitRemoteBranch getRemoteBranch() {
        GitRemoteBranch gitRemoteBranch = this.myRemoteBranch;
        if (gitRemoteBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitBranchTrackInfo", "getRemoteBranch"));
        }
        return gitRemoteBranch;
    }

    public String toString() {
        return String.format("%s->%s", this.myLocalBranch.getName(), this.myRemoteBranch.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitBranchTrackInfo that = (GitBranchTrackInfo)o;
        if (this.myMerge != that.myMerge) {
            return false;
        }
        if (this.myLocalBranch != null ? !this.myLocalBranch.equals(that.myLocalBranch) : that.myLocalBranch != null) {
            return false;
        }
        return !(this.myRemoteBranch != null ? !this.myRemoteBranch.equals(that.myRemoteBranch) : that.myRemoteBranch != null);
    }

    public int hashCode() {
        int result = this.myLocalBranch != null ? this.myLocalBranch.hashCode() : 0;
        result = 31 * result + (this.myRemoteBranch != null ? this.myRemoteBranch.hashCode() : 0);
        result = 31 * result + (this.myMerge ? 1 : 0);
        return result;
    }
}

