/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.jgit.GitHttpAdapter;
import git4idea.push.GitCommitsByBranch;
import git4idea.push.GitCommitsByRepoAndBranch;
import git4idea.push.GitPushBranchInfo;
import git4idea.push.GitPushBranchResult;
import git4idea.push.GitPushDialog;
import git4idea.push.GitPushInfo;
import git4idea.push.GitPushRejectedDetector;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSpec;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GitSimplePushResult;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.settings.GitPushSettings;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitPusher {
    static final int RECENT_COMMITS_NUMBER = 5;
    @Deprecated
    static final GitRemoteBranch NO_TARGET_BRANCH = new GitStandardRemoteBranch(GitRemote.DOT, "", GitBranch.DUMMY_HASH);
    private static final Logger LOG = Logger.getInstance(GitPusher.class);
    private static final String INDICATOR_TEXT = "Pushing";
    private static final int MAX_PUSH_ATTEMPTS = 10;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    private final GitPushSettings myPushSettings;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitPlatformFacade myPlatformFacade;

    public static void showPushDialogAndPerformPush(@NotNull Project project, @NotNull GitPlatformFacade facade) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "showPushDialogAndPerformPush"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "showPushDialogAndPerformPush"));
        }
        GitPushDialog dialog = new GitPushDialog(project);
        dialog.show();
        if (dialog.isOK()) {
            GitPusher.runPushInBackground(project, facade, dialog);
        }
    }

    private static void runPushInBackground(final @NotNull Project project, final @NotNull GitPlatformFacade facade, final @NotNull GitPushDialog dialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "runPushInBackground"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "runPushInBackground"));
        }
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "runPushInBackground"));
        }
        Task.Backgroundable task = new Task.Backgroundable(project, INDICATOR_TEXT, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher$1", "run"));
                }
                new GitPusher(project, facade, indicator).push(dialog.getPushInfo());
            }
        };
        GitVcs.runInBackground(task);
    }

    public GitPusher(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "<init>"));
        }
        this.myProject = project;
        this.myPlatformFacade = facade;
        this.myProgressIndicator = indicator;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myRepositories = this.myRepositoryManager.getRepositories();
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myPushSettings = GitPushSettings.getInstance(this.myProject);
        this.myGit = (Git)ServiceManager.getService(Git.class);
    }

    @NotNull
    GitCommitsByRepoAndBranch collectCommitsToPush(@NotNull Map<GitRepository, GitPushSpec> pushSpecs) throws VcsException {
        if (pushSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "collectCommitsToPush"));
        }
        Map<GitRepository, List<GitBranchPair>> reposAndBranchesToPush = this.prepareRepositoriesAndBranchesToPush(pushSpecs);
        HashMap<GitRepository, GitCommitsByBranch> commitsByRepoAndBranch = new HashMap<GitRepository, GitCommitsByBranch>();
        for (GitRepository repository : this.myRepositories) {
            List<GitBranchPair> branchPairs = reposAndBranchesToPush.get(repository);
            if (branchPairs == null) continue;
            GitCommitsByBranch commitsByBranch = this.collectsCommitsToPush(repository, branchPairs);
            commitsByRepoAndBranch.put(repository, commitsByBranch);
        }
        GitCommitsByRepoAndBranch gitCommitsByRepoAndBranch = new GitCommitsByRepoAndBranch(commitsByRepoAndBranch);
        if (gitCommitsByRepoAndBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "collectCommitsToPush"));
        }
        return gitCommitsByRepoAndBranch;
    }

    @NotNull
    private Map<GitRepository, List<GitBranchPair>> prepareRepositoriesAndBranchesToPush(@NotNull Map<GitRepository, GitPushSpec> pushSpecs) throws VcsException {
        if (pushSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "prepareRepositoriesAndBranchesToPush"));
        }
        HashMap<GitRepository, List<GitBranchPair>> res = new HashMap<GitRepository, List<GitBranchPair>>();
        for (GitRepository repository : this.myRepositories) {
            GitPushSpec pushSpec = pushSpecs.get(repository);
            if (pushSpec == null) continue;
            res.put(repository, Collections.singletonList(new GitBranchPair(pushSpec.getSource(), pushSpec.getDest())));
        }
        HashMap<GitRepository, List<GitBranchPair>> hashMap = res;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "prepareRepositoriesAndBranchesToPush"));
        }
        return hashMap;
    }

    @NotNull
    private GitCommitsByBranch collectsCommitsToPush(@NotNull GitRepository repository, @NotNull List<GitBranchPair> sourcesDestinations) throws VcsException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "collectsCommitsToPush"));
        }
        if (sourcesDestinations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "collectsCommitsToPush"));
        }
        HashMap<GitBranch, GitPushBranchInfo> commitsByBranch = new HashMap<GitBranch, GitPushBranchInfo>();
        for (GitBranchPair sourceDest : sourcesDestinations) {
            GitPushBranchInfo.Type type;
            List<GitCommit> commits;
            GitLocalBranch source = sourceDest.getBranch();
            GitRemoteBranch dest = sourceDest.getDest();
            assert (dest != null) : "Destination branch can't be null here for branch " + source;
            if (dest == NO_TARGET_BRANCH) {
                commits = this.collectRecentCommitsOnBranch(repository, source);
                type = GitPushBranchInfo.Type.NO_TRACKED_OR_TARGET;
            } else if (GitUtil.repoContainsRemoteBranch(repository, dest)) {
                commits = this.collectCommitsToPush(repository, source.getName(), dest.getName());
                type = GitPushBranchInfo.Type.STANDARD;
            } else {
                commits = this.collectRecentCommitsOnBranch(repository, source);
                type = GitPushBranchInfo.Type.NEW_BRANCH;
            }
            commitsByBranch.put(source, new GitPushBranchInfo(source, dest, commits, type));
        }
        GitCommitsByBranch gitCommitsByBranch = new GitCommitsByBranch(commitsByBranch);
        if (gitCommitsByBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "collectsCommitsToPush"));
        }
        return gitCommitsByBranch;
    }

    private List<GitCommit> collectRecentCommitsOnBranch(GitRepository repository, GitBranch source) throws VcsException {
        return GitHistoryUtils.history(this.myProject, repository.getRoot(), "--max-count=5", source.getName());
    }

    @NotNull
    private List<GitCommit> collectCommitsToPush(@NotNull GitRepository repository, @NotNull String source, @NotNull String destination) throws VcsException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "collectCommitsToPush"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "collectCommitsToPush"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "collectCommitsToPush"));
        }
        List<GitCommit> list = GitHistoryUtils.history(this.myProject, repository.getRoot(), destination + ".." + source);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "collectCommitsToPush"));
        }
        return list;
    }

    public void push(@NotNull GitPushInfo pushInfo) {
        if (pushInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "push"));
        }
        this.push(pushInfo, null, null, 0);
    }

    private void push(@NotNull GitPushInfo pushInfo, @Nullable GitPushResult previousResult, @Nullable UpdateSettings updateSettings, int attempt) {
        if (pushInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "push"));
        }
        GitPushResult result = this.tryPushAndGetResult(pushInfo);
        this.handleResult(pushInfo, result, previousResult, updateSettings, attempt);
    }

    @NotNull
    private GitPushResult tryPushAndGetResult(@NotNull GitPushInfo pushInfo) {
        if (pushInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "tryPushAndGetResult"));
        }
        GitPushResult pushResult = new GitPushResult(this.myProject);
        GitCommitsByRepoAndBranch commits = pushInfo.getCommits();
        for (GitRepository repository : commits.getRepositories()) {
            GitPushRepoResult repoResult;
            if (commits.get(repository).getAllCommits().size() == 0 || (repoResult = this.pushRepository(pushInfo, commits, repository)).getType() == GitPushRepoResult.Type.NOT_PUSHING) continue;
            pushResult.append(repository, repoResult);
            GitPushRepoResult.Type resultType = repoResult.getType();
            if (resultType != GitPushRepoResult.Type.CANCEL && resultType != GitPushRepoResult.Type.NOT_AUTHORIZED) continue;
            break;
        }
        this.myRepositoryManager.updateAllRepositories();
        GitPushResult gitPushResult = pushResult;
        if (gitPushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "tryPushAndGetResult"));
        }
        return gitPushResult;
    }

    @NotNull
    private GitPushRepoResult pushRepository(@NotNull GitPushInfo pushInfo, @NotNull GitCommitsByRepoAndBranch commits, @NotNull GitRepository repository) {
        if (pushInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "pushRepository"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "pushRepository"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "pushRepository"));
        }
        GitPushSpec pushSpec = pushInfo.getPushSpecs().get(repository);
        GitSimplePushResult simplePushResult = this.pushAndGetSimpleResult(repository, pushSpec, commits.get(repository));
        String output = simplePushResult.getOutput();
        switch (simplePushResult.getType()) {
            case SUCCESS: {
                GitPushRepoResult gitPushRepoResult = GitPusher.successOrErrorRepoResult(commits, repository, output, true);
                if (gitPushRepoResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushRepository"));
                }
                return gitPushRepoResult;
            }
            case ERROR: {
                GitPushRepoResult gitPushRepoResult = GitPusher.successOrErrorRepoResult(commits, repository, output, false);
                if (gitPushRepoResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushRepository"));
                }
                return gitPushRepoResult;
            }
            case REJECT: {
                GitPushRepoResult gitPushRepoResult = GitPusher.getResultFromRejectedPush(commits, repository, simplePushResult);
                if (gitPushRepoResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushRepository"));
                }
                return gitPushRepoResult;
            }
            case NOT_AUTHORIZED: {
                GitPushRepoResult gitPushRepoResult = GitPushRepoResult.notAuthorized(output);
                if (gitPushRepoResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushRepository"));
                }
                return gitPushRepoResult;
            }
            case CANCEL: {
                GitPushRepoResult gitPushRepoResult = GitPushRepoResult.cancelled(output);
                if (gitPushRepoResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushRepository"));
                }
                return gitPushRepoResult;
            }
            case NOT_PUSHED: {
                GitPushRepoResult gitPushRepoResult = GitPushRepoResult.notPushed();
                if (gitPushRepoResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushRepository"));
                }
                return gitPushRepoResult;
            }
        }
        GitPushRepoResult gitPushRepoResult = GitPushRepoResult.cancelled(output);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushRepository"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    private static GitPushRepoResult getResultFromRejectedPush(@NotNull GitCommitsByRepoAndBranch commits, @NotNull GitRepository repository, @NotNull GitSimplePushResult simplePushResult) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "getResultFromRejectedPush"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "getResultFromRejectedPush"));
        }
        if (simplePushResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "getResultFromRejectedPush"));
        }
        Collection<String> rejectedBranches = simplePushResult.getRejectedBranches();
        HashMap<GitBranch, GitPushBranchResult> resultMap = new HashMap<GitBranch, GitPushBranchResult>();
        GitCommitsByBranch commitsByBranch = commits.get(repository);
        boolean pushedBranchWasRejected = false;
        for (GitBranch branch : commitsByBranch.getBranches()) {
            GitPushBranchResult branchResult;
            if (GitPusher.branchInRejected(branch, rejectedBranches)) {
                branchResult = GitPushBranchResult.rejected();
                pushedBranchWasRejected = true;
            } else {
                branchResult = GitPusher.successfulResultForBranch(commitsByBranch, branch);
            }
            resultMap.put(branch, branchResult);
        }
        if (pushedBranchWasRejected) {
            GitPushRepoResult gitPushRepoResult = GitPushRepoResult.someRejected(resultMap, simplePushResult.getOutput());
            if (gitPushRepoResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "getResultFromRejectedPush"));
            }
            return gitPushRepoResult;
        }
        GitPushRepoResult gitPushRepoResult = GitPushRepoResult.success(resultMap, simplePushResult.getOutput());
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "getResultFromRejectedPush"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    private GitSimplePushResult pushAndGetSimpleResult(@NotNull GitRepository repository, @NotNull GitPushSpec pushSpec, @NotNull GitCommitsByBranch commitsByBranch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "pushAndGetSimpleResult"));
        }
        if (pushSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "pushAndGetSimpleResult"));
        }
        if (commitsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "pushAndGetSimpleResult"));
        }
        if (pushSpec.getDest() == NO_TARGET_BRANCH) {
            GitSimplePushResult gitSimplePushResult = GitSimplePushResult.notPushed();
            if (gitSimplePushResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushAndGetSimpleResult"));
            }
            return gitSimplePushResult;
        }
        GitRemote remote = pushSpec.getRemote();
        Collection<String> pushUrls = remote.getPushUrls();
        if (pushUrls.isEmpty()) {
            LOG.error("No urls or pushUrls are defined for " + remote);
            GitSimplePushResult gitSimplePushResult = GitSimplePushResult.error("There are no URLs defined for remote " + remote.getName());
            if (gitSimplePushResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushAndGetSimpleResult"));
            }
            return gitSimplePushResult;
        }
        String url = pushUrls.iterator().next();
        GitSimplePushResult pushResult = GitHttpAdapter.shouldUseJGit(url) ? GitHttpAdapter.push(repository, remote.getName(), url, GitPusher.formPushSpec(pushSpec, remote)) : this.pushNatively(repository, pushSpec, url);
        if (pushResult.getType() == GitSimplePushResult.Type.SUCCESS) {
            GitPusher.setUpstream(repository, pushSpec.getSource(), pushSpec.getRemote(), pushSpec.getDest());
        }
        GitSimplePushResult gitSimplePushResult = pushResult;
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushAndGetSimpleResult"));
        }
        return gitSimplePushResult;
    }

    private static void setUpstream(@NotNull GitRepository repository, @NotNull GitLocalBranch source, @NotNull GitRemote remote, @NotNull GitRemoteBranch dest) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "setUpstream"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "setUpstream"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "setUpstream"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/push/GitPusher", "setUpstream"));
        }
        if (!GitPusher.branchTrackingInfoIsSet(repository, source)) {
            Project project = repository.getProject();
            VirtualFile root = repository.getRoot();
            String branchName = source.getName();
            try {
                boolean rebase = GitPusher.getMergeOrRebaseConfig(project, root);
                GitConfigUtil.setValue(project, root, "branch." + branchName + ".remote", remote.getName(), new String[0]);
                GitConfigUtil.setValue(project, root, "branch." + branchName + ".merge", "refs/heads/" + dest.getNameForRemoteOperations(), new String[0]);
                if (rebase) {
                    GitConfigUtil.setValue(project, root, "branch." + branchName + ".rebase", "true", new String[0]);
                }
            }
            catch (VcsException e) {
                LOG.error(String.format("Couldn't set up tracking for source branch %s, target branch %s, remote %s in root %s", source, dest, remote, repository), (Throwable)e);
                VcsNotifier.getInstance((Project)project).notifyWeakError("Couldn't set up branch tracking");
            }
        }
    }

    private static boolean getMergeOrRebaseConfig(Project project, VirtualFile root) throws VcsException {
        String autoSetupRebase = GitConfigUtil.getValue(project, root, "branch.autosetuprebase");
        return autoSetupRebase != null && (autoSetupRebase.equals("remote") || autoSetupRebase.equals("always"));
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository, @NotNull GitLocalBranch source) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "branchTrackingInfoIsSet"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "branchTrackingInfoIsSet"));
        }
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!trackInfo.getLocalBranch().equals(source)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String formPushSpec(@NotNull GitPushSpec spec, @NotNull GitRemote remote) {
        String destName;
        String prefix;
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "formPushSpec"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "formPushSpec"));
        }
        String destWithRemote = spec.getDest().getName();
        if (destWithRemote.startsWith(prefix = remote.getName() + "/")) {
            destName = destWithRemote.substring(prefix.length());
        } else {
            LOG.error("Destination remote branch has invalid name. Remote branch name: " + destWithRemote + "\nRemote: " + remote);
            destName = destWithRemote;
        }
        String string = spec.getSource().getName() + ":" + destName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "formPushSpec"));
        }
        return string;
    }

    @NotNull
    private GitSimplePushResult pushNatively(GitRepository repository, GitPushSpec pushSpec, @NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "pushNatively"));
        }
        GitPushRejectedDetector rejectedDetector = new GitPushRejectedDetector();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        GitCommandResult res = this.myGit.push(repository, pushSpec, url, rejectedDetector, progressListener);
        if (rejectedDetector.rejected()) {
            Collection<String> rejectedBranches = rejectedDetector.getRejectedBranches();
            GitSimplePushResult gitSimplePushResult = GitSimplePushResult.reject(rejectedBranches);
            if (gitSimplePushResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushNatively"));
            }
            return gitSimplePushResult;
        }
        if (res.success()) {
            GitSimplePushResult gitSimplePushResult = GitSimplePushResult.success();
            if (gitSimplePushResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushNatively"));
            }
            return gitSimplePushResult;
        }
        GitSimplePushResult gitSimplePushResult = GitSimplePushResult.error(res.getErrorOutputAsHtmlString());
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "pushNatively"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    private static GitPushRepoResult successOrErrorRepoResult(@NotNull GitCommitsByRepoAndBranch commits, @NotNull GitRepository repository, @NotNull String output, boolean success) {
        GitPushRepoResult repoResult;
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "successOrErrorRepoResult"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "successOrErrorRepoResult"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPusher", "successOrErrorRepoResult"));
        }
        HashMap<GitBranch, GitPushBranchResult> resultMap = new HashMap<GitBranch, GitPushBranchResult>();
        GitCommitsByBranch commitsByBranch = commits.get(repository);
        for (GitBranch branch : commitsByBranch.getBranches()) {
            GitPushBranchResult branchResult = success ? GitPusher.successfulResultForBranch(commitsByBranch, branch) : GitPushBranchResult.error();
            resultMap.put(branch, branchResult);
        }
        GitPushRepoResult gitPushRepoResult = repoResult = success ? GitPushRepoResult.success(resultMap, output) : GitPushRepoResult.error(resultMap, output);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "successOrErrorRepoResult"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    private static GitPushBranchResult successfulResultForBranch(@NotNull GitCommitsByBranch commitsByBranch, @NotNull GitBranch branch) {
        if (commitsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "successfulResultForBranch"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "successfulResultForBranch"));
        }
        GitPushBranchInfo branchInfo = commitsByBranch.get(branch);
        if (branchInfo.isNewBranchCreated()) {
            GitPushBranchResult gitPushBranchResult = GitPushBranchResult.newBranch(branchInfo.getDestBranch().getName());
            if (gitPushBranchResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "successfulResultForBranch"));
            }
            return gitPushBranchResult;
        }
        GitPushBranchResult gitPushBranchResult = GitPushBranchResult.success(branchInfo.getCommits().size());
        if (gitPushBranchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "successfulResultForBranch"));
        }
        return gitPushBranchResult;
    }

    private static boolean branchInRejected(@NotNull GitBranch branch, @NotNull Collection<String> rejectedBranches) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "branchInRejected"));
        }
        if (rejectedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "branchInRejected"));
        }
        String branchName = branch.getName();
        String REFS_HEADS = "refs/heads/";
        if (branchName.startsWith("refs/heads/")) {
            branchName = branchName.substring("refs/heads/".length());
        }
        for (String rejectedBranch : rejectedBranches) {
            if (!rejectedBranch.equals(branchName) && (!rejectedBranch.startsWith("refs/heads/") || !rejectedBranch.substring("refs/heads/".length()).equals(branchName))) continue;
            return true;
        }
        return false;
    }

    private void handleResult(@NotNull GitPushInfo pushInfo, @NotNull GitPushResult result, @Nullable GitPushResult previousResult, @Nullable UpdateSettings updateSettings, int pushAttempt) {
        if (pushInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "handleResult"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "handleResult"));
        }
        result.mergeFrom(previousResult);
        if (result.isEmpty()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyInfo("Nothing to push");
        } else if (result.wasErrorCancelOrNotAuthorized()) {
            result.createPushNotificationAndNotify();
        } else {
            Map<GitRepository, GitBranch> rejectedPushesForCurrentBranch = result.getRejectedPushesFromCurrentBranchToTrackedBranch(pushInfo);
            if (pushAttempt <= 10 && !rejectedPushesForCurrentBranch.isEmpty()) {
                LOG.info(String.format("Rejected pushes for current branches: %n%s%nUpdate settings: %s", rejectedPushesForCurrentBranch, updateSettings));
                if (updateSettings == null) {
                    updateSettings = this.readUpdateSettings();
                    if (!this.mySettings.autoUpdateIfPushRejected()) {
                        GitRejectedPushUpdateDialog dialog = new GitRejectedPushUpdateDialog(this.myProject, rejectedPushesForCurrentBranch.keySet(), updateSettings);
                        int exitCode = this.showDialogAndGetExitCode(dialog);
                        updateSettings = new UpdateSettings(dialog.shouldUpdateAll(), GitPusher.getUpdateMethodFromDialogExitCode(exitCode));
                        this.saveUpdateSettings(updateSettings);
                    }
                }
                if (updateSettings.shouldUpdate()) {
                    Collection<GitRepository> repositoriesToUpdate = this.getRootsToUpdate(rejectedPushesForCurrentBranch, updateSettings.shouldUpdateAllRoots());
                    GitPushResult adjustedPushResult = result.remove(rejectedPushesForCurrentBranch);
                    adjustedPushResult.markUpdateStartIfNotMarked(repositoriesToUpdate);
                    boolean updateResult = this.update(repositoriesToUpdate, updateSettings.getUpdateMethod());
                    if (updateResult) {
                        this.myProgressIndicator.setText(INDICATOR_TEXT);
                        GitPushInfo newPushInfo = pushInfo.retain(rejectedPushesForCurrentBranch);
                        this.push(newPushInfo, adjustedPushResult, updateSettings, pushAttempt + 1);
                        return;
                    }
                }
            }
            result.createPushNotificationAndNotify();
        }
    }

    private void saveUpdateSettings(@NotNull UpdateSettings updateSettings) {
        if (updateSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "saveUpdateSettings"));
        }
        UpdateMethod updateMethod = updateSettings.getUpdateMethod();
        if (updateMethod != null) {
            this.myPushSettings.setUpdateAllRoots(updateSettings.shouldUpdateAllRoots());
            this.myPushSettings.setUpdateMethod(updateMethod);
        }
    }

    @NotNull
    private UpdateSettings readUpdateSettings() {
        boolean updateAllRoots = this.myPushSettings.shouldUpdateAllRoots();
        UpdateMethod updateMethod = this.myPushSettings.getUpdateMethod();
        UpdateSettings updateSettings = new UpdateSettings(updateAllRoots, updateMethod);
        if (updateSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "readUpdateSettings"));
        }
        return updateSettings;
    }

    private int showDialogAndGetExitCode(final @NotNull GitRejectedPushUpdateDialog dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "showDialogAndGetExitCode"));
        }
        final AtomicInteger exitCode = new AtomicInteger();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.show();
                exitCode.set(dialog.getExitCode());
            }
        });
        int code = exitCode.get();
        if (code != 1) {
            this.mySettings.setAutoUpdateIfPushRejected(dialog.shouldAutoUpdateInFuture());
        }
        return code;
    }

    @Nullable
    private static UpdateMethod getUpdateMethodFromDialogExitCode(int exitCode) {
        switch (exitCode) {
            case 2: {
                return UpdateMethod.MERGE;
            }
            case 3: {
                return UpdateMethod.REBASE;
            }
        }
        return null;
    }

    @NotNull
    private Collection<GitRepository> getRootsToUpdate(@NotNull Map<GitRepository, GitBranch> rejectedPushesForCurrentBranch, boolean updateAllRoots) {
        if (rejectedPushesForCurrentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "getRootsToUpdate"));
        }
        Collection<GitRepository> collection = updateAllRoots ? this.myRepositories : rejectedPushesForCurrentBranch.keySet();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPusher", "getRootsToUpdate"));
        }
        return collection;
    }

    private boolean update(@NotNull Collection<GitRepository> rootsToUpdate, @NotNull UpdateMethod updateMethod) {
        if (rootsToUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPusher", "update"));
        }
        if (updateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPusher", "update"));
        }
        GitUpdateProcess.UpdateMethod um = updateMethod == UpdateMethod.MERGE ? GitUpdateProcess.UpdateMethod.MERGE : GitUpdateProcess.UpdateMethod.REBASE;
        GitUpdateResult updateResult = new GitUpdateProcess(this.myProject, this.myPlatformFacade, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create()).update(um);
        for (GitRepository repository : rootsToUpdate) {
            repository.getRoot().refresh(true, true);
        }
        if (updateResult == GitUpdateResult.SUCCESS) {
            return true;
        }
        if (updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS || updateResult == GitUpdateResult.INCOMPLETE) {
            String title = "Push cancelled";
            String description = updateResult == GitUpdateResult.INCOMPLETE ? "Push has been cancelled, because not all conflicts were resolved during update.<br/>Resolve the conflicts and invoke push again." : "Push has been cancelled, because there were conflicts during update.<br/>Check that conflicts were resolved correctly, and invoke push again.";
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning(title, description);
            return false;
        }
        return false;
    }

    static class UpdateSettings {
        private final boolean myUpdateAllRoots;
        private final UpdateMethod myUpdateMethod;

        private UpdateSettings(boolean updateAllRoots, UpdateMethod updateMethod) {
            this.myUpdateAllRoots = updateAllRoots;
            this.myUpdateMethod = updateMethod;
        }

        public boolean shouldUpdateAllRoots() {
            return this.myUpdateAllRoots;
        }

        public UpdateMethod getUpdateMethod() {
            return this.myUpdateMethod;
        }

        public boolean shouldUpdate() {
            return this.getUpdateMethod() != null;
        }

        public String toString() {
            return String.format("UpdateSettings{myUpdateAllRoots=%s, myUpdateMethod=%s}", new Object[]{this.myUpdateAllRoots, this.myUpdateMethod});
        }
    }
}

