/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitRemote;
import org.jetbrains.annotations.NotNull;

public class GitPushSpec {
    @NotNull
    private final GitLocalBranch mySource;
    @NotNull
    private final GitRemoteBranch myDest;

    GitPushSpec(@NotNull GitLocalBranch source, @NotNull GitRemoteBranch dest) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushSpec", "<init>"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushSpec", "<init>"));
        }
        this.myDest = dest;
        this.mySource = source;
    }

    @NotNull
    public GitRemote getRemote() {
        GitRemote gitRemote = this.myDest.getRemote();
        if (gitRemote == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSpec", "getRemote"));
        }
        return gitRemote;
    }

    @NotNull
    public GitLocalBranch getSource() {
        GitLocalBranch gitLocalBranch = this.mySource;
        if (gitLocalBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSpec", "getSource"));
        }
        return gitLocalBranch;
    }

    @NotNull
    public GitRemoteBranch getDest() {
        GitRemoteBranch gitRemoteBranch = this.myDest;
        if (gitRemoteBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSpec", "getDest"));
        }
        return gitRemoteBranch;
    }

    public String toString() {
        return this.mySource + "->" + this.myDest;
    }
}

