/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushBranchResult;
import git4idea.push.GitPushInfo;
import git4idea.push.GitPushRepoResult;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushResult {
    private static final Logger LOG = Logger.getInstance(GitPushResult.class);
    private final Project myProject;
    private final Map<GitRepository, GitPushRepoResult> myResults;
    private final Map<GitRepository, GitRevisionNumber> myUpdateStarts;
    private Label myBeforeUpdateLabel;

    GitPushResult(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult", "<init>"));
        }
        this(project, null, new HashMap<GitRepository, GitRevisionNumber>());
    }

    private GitPushResult(@NotNull Project project, @Nullable Label beforeUpdateLabel, @NotNull Map<GitRepository, GitRevisionNumber> updateStarts) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult", "<init>"));
        }
        if (updateStarts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPushResult", "<init>"));
        }
        this.myResults = new HashMap<GitRepository, GitPushRepoResult>();
        this.myUpdateStarts = new HashMap<GitRepository, GitRevisionNumber>();
        this.myProject = project;
        this.myBeforeUpdateLabel = beforeUpdateLabel;
        for (Map.Entry<GitRepository, GitRevisionNumber> entry : updateStarts.entrySet()) {
            this.myUpdateStarts.put(entry.getKey(), entry.getValue());
        }
    }

    void append(@NotNull GitRepository repository, @NotNull GitPushRepoResult result) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult", "append"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushResult", "append"));
        }
        this.myResults.put(repository, result);
    }

    void markUpdateStartIfNotMarked(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult", "markUpdateStartIfNotMarked"));
        }
        if (this.myUpdateStarts.isEmpty()) {
            this.myBeforeUpdateLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before push");
        }
        for (GitRepository repository : repositories) {
            String currentRevision;
            if (this.myUpdateStarts.containsKey(repository) || (currentRevision = repository.getCurrentRevision()) == null) continue;
            this.myUpdateStarts.put(repository, new GitRevisionNumber(currentRevision));
        }
    }

    boolean wasErrorCancelOrNotAuthorized() {
        for (GitPushRepoResult repoResult : this.myResults.values()) {
            if (!repoResult.isOneOfErrors()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private GroupedResult group() {
        HashMap<GitRepository, GitPushRepoResult> successfulResults = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitPushRepoResult> errorResults = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitPushRepoResult> rejectedResults = new HashMap<GitRepository, GitPushRepoResult>();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : this.myResults.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult repoResult = entry.getValue();
            switch (repoResult.getType()) {
                case SUCCESS: {
                    successfulResults.put(repository, repoResult);
                    break;
                }
                case ERROR: 
                case CANCEL: 
                case NOT_AUTHORIZED: {
                    errorResults.put(repository, repoResult);
                    break;
                }
                case NOT_PUSHING: {
                    break;
                }
                case SOME_REJECTED: {
                    rejectedResults.put(repository, repoResult);
                }
            }
        }
        GroupedResult groupedResult = new GroupedResult(successfulResults, errorResults, rejectedResults);
        if (groupedResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushResult", "group"));
        }
        return groupedResult;
    }

    boolean isEmpty() {
        return this.myResults.isEmpty();
    }

    @NotNull
    GitPushResult remove(@NotNull Map<GitRepository, GitBranch> repoBranchPairs) {
        if (repoBranchPairs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult", "remove"));
        }
        GitPushResult result = new GitPushResult(this.myProject, this.myBeforeUpdateLabel, this.myUpdateStarts);
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : this.myResults.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult repoResult = entry.getValue();
            if (repoBranchPairs.containsKey(repository)) {
                GitPushRepoResult adjustedResult = repoResult.remove(repoBranchPairs.get(repository));
                if (repoResult.isEmpty()) continue;
                result.append(repository, adjustedResult);
                continue;
            }
            result.append(repository, repoResult);
        }
        GitPushResult gitPushResult = result;
        if (gitPushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushResult", "remove"));
        }
        return gitPushResult;
    }

    void mergeFrom(@Nullable GitPushResult previousResult) {
        if (previousResult == null) {
            return;
        }
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : previousResult.myResults.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult repoResult = entry.getValue();
            if (this.myResults.containsKey(repository)) {
                this.myResults.get(repository).mergeFrom(previousResult.myResults.get(repository));
                continue;
            }
            this.append(repository, repoResult);
        }
        for (Map.Entry<GitRepository, Object> entry : previousResult.myUpdateStarts.entrySet()) {
            this.myUpdateStarts.put(entry.getKey(), (GitRevisionNumber)entry.getValue());
        }
        this.myBeforeUpdateLabel = previousResult.myBeforeUpdateLabel;
    }

    @NotNull
    Map<GitRepository, GitBranch> getRejectedPushesFromCurrentBranchToTrackedBranch(GitPushInfo pushInfo) {
        HashMap<GitRepository, GitBranch> rejectedPushesForCurrentBranch = new HashMap<GitRepository, GitBranch>();
        for (Map.Entry entry : this.group().myRejectedResults.entrySet()) {
            String trackedBranchName;
            GitPushRepoResult repoResult;
            GitPushBranchResult curBranchResult;
            GitRepository repository = (GitRepository)entry.getKey();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            if (currentBranch == null || (curBranchResult = (repoResult = (GitPushRepoResult)entry.getValue()).getBranchResults().get(currentBranch)) == null) continue;
            try {
                String remote;
                String simpleName = GitBranchUtil.getTrackedBranchName(this.myProject, repository.getRoot(), currentBranch.getName());
                if (simpleName == null) continue;
                if (simpleName.startsWith("refs/heads/")) {
                    simpleName = simpleName.substring("refs/heads/".length());
                }
                if ((remote = GitBranchUtil.getTrackedRemoteName(this.myProject, repository.getRoot(), currentBranch.getName())) == null) continue;
                trackedBranchName = remote + "/" + simpleName;
            }
            catch (VcsException e) {
                LOG.info("Couldn't get tracked branch for branch " + currentBranch, (Throwable)e);
                continue;
            }
            if (!pushInfo.getPushSpecs().get(repository).getDest().getName().equals(trackedBranchName) || !curBranchResult.isRejected()) continue;
            rejectedPushesForCurrentBranch.put(repository, currentBranch);
        }
        HashMap<GitRepository, GitBranch> hashMap = rejectedPushesForCurrentBranch;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushResult", "getRejectedPushesFromCurrentBranchToTrackedBranch"));
        }
        return hashMap;
    }

    void createPushNotificationAndNotify() {
        String title;
        UpdatedFiles updatedFiles = this.collectUpdatedFiles();
        GroupedResult groupedResult = this.group();
        boolean error = !groupedResult.myErrorResults.isEmpty();
        boolean rejected = !groupedResult.myRejectedResults.isEmpty();
        boolean success = !groupedResult.mySuccessfulResults.isEmpty();
        boolean onlyError = error && !rejected && !success;
        boolean onlyRejected = rejected && !error && !success;
        boolean onlySuccess = success && !rejected && !error;
        int pushedCommitsNumber = GitPushResult.calcPushedCommitTotalNumber(this.myResults);
        if (error) {
            if (onlyError) {
                title = "Push failed";
            } else {
                title = "Push partially failed";
                if (success) {
                    title = title + ", " + GitPushResult.commits(pushedCommitsNumber) + " pushed";
                }
            }
        } else {
            title = rejected ? (onlyRejected ? "Push rejected" : "Push partially rejected, " + GitPushResult.commits(pushedCommitsNumber) + " pushed") : "Push successful";
        }
        String errorReport = this.reportForGroup(groupedResult.myErrorResults, GroupedResult.Type.ERROR);
        String successReport = this.reportForGroup(groupedResult.mySuccessfulResults, GroupedResult.Type.SUCCESS);
        String rejectedReport = this.reportForGroup(groupedResult.myRejectedResults, GroupedResult.Type.REJECT);
        StringBuilder sb = new StringBuilder();
        sb.append(errorReport);
        sb.append(rejectedReport);
        sb.append(successReport);
        if (!updatedFiles.isEmpty()) {
            sb.append("<a href='UpdatedFiles'>View files updated during the push</a>");
        }
        ViewUpdatedFilesNotificationListener viewUpdateFilesListener = new ViewUpdatedFilesNotificationListener(updatedFiles);
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
        if (onlySuccess) {
            vcsNotifier.notifySuccess(title, sb.toString(), (NotificationListener)viewUpdateFilesListener);
        } else if (error) {
            vcsNotifier.notifyError(title, sb.toString(), (NotificationListener)viewUpdateFilesListener);
        } else {
            vcsNotifier.notifyImportantWarning(title, sb.toString(), (NotificationListener)viewUpdateFilesListener);
        }
    }

    @NotNull
    private UpdatedFiles collectUpdatedFiles() {
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitRevisionNumber> updatedRepository : this.myUpdateStarts.entrySet()) {
            GitRepository repository = updatedRepository.getKey();
            MergeChangeCollector collector = new MergeChangeCollector(this.myProject, repository.getRoot(), updatedRepository.getValue());
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            collector.collect(updatedFiles, exceptions);
            for (VcsException exception : exceptions) {
                LOG.info((Throwable)exception);
            }
        }
        UpdatedFiles updatedFiles2 = updatedFiles;
        if (updatedFiles2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushResult", "collectUpdatedFiles"));
        }
        return updatedFiles2;
    }

    private static int calcPushedCommitTotalNumber(@NotNull Map<GitRepository, GitPushRepoResult> successfulResults) {
        if (successfulResults == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult", "calcPushedCommitTotalNumber"));
        }
        int sum = 0;
        for (GitPushRepoResult pushRepoResult : successfulResults.values()) {
            for (GitPushBranchResult branchResult : pushRepoResult.getBranchResults().values()) {
                sum += branchResult.getNumberOfPushedCommits();
            }
        }
        return sum;
    }

    @NotNull
    private String reportForGroup(@NotNull Map<GitRepository, GitPushRepoResult> groupResult, @NotNull GroupedResult.Type resultType) {
        if (groupResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult", "reportForGroup"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushResult", "reportForGroup"));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : groupResult.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult result = entry.getValue();
            if (!GitUtil.justOneGitRepository(this.myProject)) {
                sb.append("<code>" + repository.getPresentableUrl() + "</code>:<br/>");
            }
            if (resultType == GroupedResult.Type.SUCCESS || resultType == GroupedResult.Type.REJECT) {
                sb.append(result.getPerBranchesNonErrorReport());
            } else {
                sb.append(result.getOutput());
            }
            sb.append("<br/>");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushResult", "reportForGroup"));
        }
        return string;
    }

    @NotNull
    private static String commits(int commitNum) {
        String string = commitNum + " " + StringUtil.pluralize((String)"commit", (int)commitNum);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushResult", "commits"));
        }
        return string;
    }

    private class ViewUpdatedFilesNotificationListener
    implements NotificationListener {
        private final UpdatedFiles myUpdatedFiles;

        public ViewUpdatedFilesNotificationListener(UpdatedFiles updatedFiles) {
            this.myUpdatedFiles = updatedFiles;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult$ViewUpdatedFilesNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushResult$ViewUpdatedFilesNotificationListener", "hyperlinkUpdate"));
            }
            if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                if (event.getDescription().equals("UpdatedFiles")) {
                    ProjectLevelVcsManagerEx vcsManager = ProjectLevelVcsManagerEx.getInstanceEx((Project)GitPushResult.this.myProject);
                    UpdateInfoTree tree = vcsManager.showUpdateProjectInfo(this.myUpdatedFiles, "Update", ActionInfo.UPDATE, false);
                    tree.setBefore(GitPushResult.this.myBeforeUpdateLabel);
                    tree.setAfter(LocalHistory.getInstance().putSystemLabel(GitPushResult.this.myProject, "After push"));
                } else {
                    BrowserUtil.browse((String)event.getDescription());
                }
            }
        }
    }

    private static class GroupedResult {
        private final Map<GitRepository, GitPushRepoResult> mySuccessfulResults;
        private final Map<GitRepository, GitPushRepoResult> myErrorResults;
        private final Map<GitRepository, GitPushRepoResult> myRejectedResults;

        GroupedResult(@NotNull Map<GitRepository, GitPushRepoResult> successfulResults, @NotNull Map<GitRepository, GitPushRepoResult> errorResults, @NotNull Map<GitRepository, GitPushRepoResult> rejectedResults) {
            if (successfulResults == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushResult$GroupedResult", "<init>"));
            }
            if (errorResults == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushResult$GroupedResult", "<init>"));
            }
            if (rejectedResults == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPushResult$GroupedResult", "<init>"));
            }
            this.mySuccessfulResults = successfulResults;
            this.myErrorResults = errorResults;
            this.myRejectedResults = rejectedResults;
        }

        static enum Type {
            SUCCESS,
            REJECT,
            ERROR;

        }
    }
}

