/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitBranch;
import git4idea.push.GitPushBranchResult;
import git4idea.util.GitUIUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class GitPushRepoResult {
    private final Type myType;
    private final String myOutput;
    private final Map<GitBranch, GitPushBranchResult> myBranchResults;

    GitPushRepoResult(@NotNull Type type, @NotNull Map<GitBranch, GitPushBranchResult> resultsByBranch, @NotNull String output) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        if (resultsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPushRepoResult", "<init>"));
        }
        this.myType = type;
        this.myBranchResults = resultsByBranch;
        this.myOutput = output;
    }

    @NotNull
    static GitPushRepoResult success(@NotNull Map<GitBranch, GitPushBranchResult> resultsByBranch, @NotNull String output) {
        if (resultsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "success"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushRepoResult", "success"));
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.SUCCESS, resultsByBranch, output);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "success"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult error(@NotNull Map<GitBranch, GitPushBranchResult> resultsByBranch, @NotNull String output) {
        if (resultsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "error"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushRepoResult", "error"));
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.ERROR, resultsByBranch, output);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "error"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult someRejected(@NotNull Map<GitBranch, GitPushBranchResult> resultsByBranch, @NotNull String output) {
        if (resultsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "someRejected"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushRepoResult", "someRejected"));
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.SOME_REJECTED, resultsByBranch, output);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "someRejected"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    public static GitPushRepoResult cancelled(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "cancelled"));
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.CANCEL, Collections.<GitBranch, GitPushBranchResult>emptyMap(), output);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "cancelled"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    public static GitPushRepoResult notAuthorized(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "notAuthorized"));
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.NOT_AUTHORIZED, Collections.<GitBranch, GitPushBranchResult>emptyMap(), output);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "notAuthorized"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    static GitPushRepoResult notPushed() {
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(Type.NOT_PUSHING, Collections.<GitBranch, GitPushBranchResult>emptyMap(), "");
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "notPushed"));
        }
        return gitPushRepoResult;
    }

    @NotNull
    Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getType"));
        }
        return type;
    }

    boolean isOneOfErrors() {
        return this.myType == Type.ERROR || this.myType == Type.CANCEL || this.myType == Type.NOT_AUTHORIZED;
    }

    @NotNull
    String getOutput() {
        String string = this.myOutput;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getOutput"));
        }
        return string;
    }

    @NotNull
    Map<GitBranch, GitPushBranchResult> getBranchResults() {
        Map<GitBranch, GitPushBranchResult> map = this.myBranchResults;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getBranchResults"));
        }
        return map;
    }

    @NotNull
    GitPushRepoResult remove(@NotNull GitBranch branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "remove"));
        }
        HashMap<GitBranch, GitPushBranchResult> resultsByBranch = new HashMap<GitBranch, GitPushBranchResult>();
        for (Map.Entry<GitBranch, GitPushBranchResult> entry : this.myBranchResults.entrySet()) {
            GitBranch b = entry.getKey();
            if (b.equals(branch)) continue;
            resultsByBranch.put(b, entry.getValue());
        }
        GitPushRepoResult gitPushRepoResult = new GitPushRepoResult(this.myType, resultsByBranch, this.myOutput);
        if (gitPushRepoResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "remove"));
        }
        return gitPushRepoResult;
    }

    boolean isEmpty() {
        return this.myBranchResults.isEmpty();
    }

    void mergeFrom(@NotNull GitPushRepoResult repoResult) {
        if (repoResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushRepoResult", "mergeFrom"));
        }
        for (Map.Entry<GitBranch, GitPushBranchResult> entry : repoResult.myBranchResults.entrySet()) {
            GitBranch branch = entry.getKey();
            GitPushBranchResult branchResult = entry.getValue();
            if (this.myBranchResults.containsKey(branch)) continue;
            this.myBranchResults.put(branch, branchResult);
        }
    }

    @NotNull
    String getPerBranchesNonErrorReport() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<GitBranch, GitPushBranchResult> entry : this.myBranchResults.entrySet()) {
            GitBranch branch = entry.getKey();
            GitPushBranchResult branchResult = entry.getValue();
            if (branchResult.isSuccess()) {
                sb.append(GitUIUtil.bold(branch.getName()) + ": pushed " + GitPushRepoResult.commits(branchResult.getNumberOfPushedCommits()));
            } else if (branchResult.isNewBranch()) {
                sb.append(GitUIUtil.bold(branch.getName()) + " pushed to new branch " + GitUIUtil.bold(branchResult.getTargetBranchName()));
            } else {
                sb.append(GitUIUtil.code(branch.getName())).append(": rejected");
            }
            if (i >= this.myBranchResults.size() - 1) continue;
            sb.append("<br/>");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "getPerBranchesNonErrorReport"));
        }
        return string;
    }

    @NotNull
    private static String commits(int commitNum) {
        String string = commitNum + " " + StringUtil.pluralize((String)"commit", (int)commitNum);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushRepoResult", "commits"));
        }
        return string;
    }

    static enum Type {
        NOT_PUSHING,
        SUCCESS,
        SOME_REJECTED,
        ERROR,
        CANCEL,
        NOT_AUTHORIZED;

    }
}

