/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.util.containers.HashMap;
import git4idea.GitBranch;
import git4idea.push.GitCommitsByRepoAndBranch;
import git4idea.push.GitPushSpec;
import git4idea.repo.GitRepository;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitPushInfo {
    @NotNull
    private final GitCommitsByRepoAndBranch myCommits;
    @NotNull
    private final Map<GitRepository, GitPushSpec> myPushSpecs;

    public GitPushInfo(@NotNull GitCommitsByRepoAndBranch commits, @NotNull Map<GitRepository, GitPushSpec> pushSpecs) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushInfo", "<init>"));
        }
        if (pushSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushInfo", "<init>"));
        }
        this.myCommits = commits;
        this.myPushSpecs = pushSpecs;
    }

    @NotNull
    public Map<GitRepository, GitPushSpec> getPushSpecs() {
        Map<GitRepository, GitPushSpec> map = this.myPushSpecs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushInfo", "getPushSpecs"));
        }
        return map;
    }

    @NotNull
    public GitCommitsByRepoAndBranch getCommits() {
        GitCommitsByRepoAndBranch gitCommitsByRepoAndBranch = this.myCommits;
        if (gitCommitsByRepoAndBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushInfo", "getCommits"));
        }
        return gitCommitsByRepoAndBranch;
    }

    @NotNull
    public GitPushInfo retain(Map<GitRepository, GitBranch> repoBranchMap) {
        GitPushInfo gitPushInfo = new GitPushInfo(this.myCommits.retainAll(repoBranchMap), (Map<GitRepository, GitPushSpec>)new HashMap(this.myPushSpecs));
        if (gitPushInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushInfo", "retain"));
        }
        return gitPushInfo;
    }
}

