/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class GitPushBranchInfo {
    private final GitLocalBranch mySourceBranch;
    private final GitRemoteBranch myDestBranch;
    private final Type myType;
    private final List<GitCommit> myCommits;

    GitPushBranchInfo(@NotNull GitLocalBranch sourceBranch, @NotNull GitRemoteBranch destBranch, @NotNull List<GitCommit> commits, @NotNull Type type) {
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushBranchInfo", "<init>"));
        }
        if (destBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushBranchInfo", "<init>"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPushBranchInfo", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/push/GitPushBranchInfo", "<init>"));
        }
        this.mySourceBranch = sourceBranch;
        this.myCommits = commits;
        this.myDestBranch = destBranch;
        this.myType = type;
    }

    GitPushBranchInfo(@NotNull GitPushBranchInfo pushBranchInfo) {
        if (pushBranchInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushBranchInfo", "<init>"));
        }
        this(pushBranchInfo.getSourceBranch(), pushBranchInfo.getDestBranch(), pushBranchInfo.getCommits(), pushBranchInfo.getType());
    }

    @NotNull
    Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushBranchInfo", "getType"));
        }
        return type;
    }

    boolean isNewBranchCreated() {
        return this.myType == Type.NEW_BRANCH;
    }

    @NotNull
    GitRemoteBranch getDestBranch() {
        GitRemoteBranch gitRemoteBranch = this.myDestBranch;
        if (gitRemoteBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushBranchInfo", "getDestBranch"));
        }
        return gitRemoteBranch;
    }

    @NotNull
    List<GitCommit> getCommits() {
        ArrayList<GitCommit> arrayList = new ArrayList<GitCommit>(this.myCommits);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushBranchInfo", "getCommits"));
        }
        return arrayList;
    }

    @NotNull
    public GitLocalBranch getSourceBranch() {
        GitLocalBranch gitLocalBranch = this.mySourceBranch;
        if (gitLocalBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushBranchInfo", "getSourceBranch"));
        }
        return gitLocalBranch;
    }

    boolean isEmpty() {
        return this.myCommits.isEmpty();
    }

    static enum Type {
        STANDARD,
        NEW_BRANCH,
        NO_TRACKED_OR_TARGET;

    }
}

