/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.push.GitCommitsByBranch;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class GitCommitsByRepoAndBranch {
    private final Map<GitRepository, GitCommitsByBranch> myCommitsByRepository;

    GitCommitsByRepoAndBranch(@NotNull Map<GitRepository, GitCommitsByBranch> commitsByRepository) {
        if (commitsByRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitCommitsByRepoAndBranch", "<init>"));
        }
        this.myCommitsByRepository = commitsByRepository;
    }

    @NotNull
    static GitCommitsByRepoAndBranch empty() {
        GitCommitsByRepoAndBranch gitCommitsByRepoAndBranch = new GitCommitsByRepoAndBranch(new HashMap<GitRepository, GitCommitsByBranch>());
        if (gitCommitsByRepoAndBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByRepoAndBranch", "empty"));
        }
        return gitCommitsByRepoAndBranch;
    }

    @NotNull
    Collection<GitRepository> getRepositories() {
        HashSet<GitRepository> hashSet = new HashSet<GitRepository>(this.myCommitsByRepository.keySet());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByRepoAndBranch", "getRepositories"));
        }
        return hashSet;
    }

    @NotNull
    GitCommitsByBranch get(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitCommitsByRepoAndBranch", "get"));
        }
        GitCommitsByBranch gitCommitsByBranch = new GitCommitsByBranch(this.myCommitsByRepository.get(repository));
        if (gitCommitsByBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByRepoAndBranch", "get"));
        }
        return gitCommitsByBranch;
    }

    @NotNull
    GitCommitsByRepoAndBranch retainAll(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitCommitsByRepoAndBranch", "retainAll"));
        }
        HashMap<GitRepository, GitCommitsByBranch> commits = new HashMap<GitRepository, GitCommitsByBranch>();
        for (GitRepository selectedRepository : repositories) {
            GitCommitsByBranch value = this.myCommitsByRepository.get(selectedRepository);
            if (value == null) continue;
            commits.put(selectedRepository, value);
        }
        GitCommitsByRepoAndBranch gitCommitsByRepoAndBranch = new GitCommitsByRepoAndBranch(commits);
        if (gitCommitsByRepoAndBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByRepoAndBranch", "retainAll"));
        }
        return gitCommitsByRepoAndBranch;
    }

    @NotNull
    GitCommitsByRepoAndBranch retainAll(@NotNull Map<GitRepository, GitBranch> repositoriesBranches) {
        if (repositoriesBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitCommitsByRepoAndBranch", "retainAll"));
        }
        HashMap<GitRepository, GitCommitsByBranch> commits = new HashMap<GitRepository, GitCommitsByBranch>();
        for (GitRepository repository : repositoriesBranches.keySet()) {
            GitCommitsByBranch commitsByBranch = this.myCommitsByRepository.get(repository);
            if (commitsByBranch == null) continue;
            commits.put(repository, commitsByBranch.retain(repositoriesBranches.get(repository)));
        }
        GitCommitsByRepoAndBranch gitCommitsByRepoAndBranch = new GitCommitsByRepoAndBranch(commits);
        if (gitCommitsByRepoAndBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByRepoAndBranch", "retainAll"));
        }
        return gitCommitsByRepoAndBranch;
    }

    @NotNull
    public Collection<GitCommit> getAllCommits() {
        ArrayList<GitCommit> commits = new ArrayList<GitCommit>();
        for (GitCommitsByBranch commitsByBranch : this.myCommitsByRepository.values()) {
            commits.addAll(commitsByBranch.getAllCommits());
        }
        ArrayList<GitCommit> arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByRepoAndBranch", "getAllCommits"));
        }
        return arrayList;
    }
}

