/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.push.GitPushBranchInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class GitCommitsByBranch {
    private final Map<GitBranch, GitPushBranchInfo> myCommitsByBranch;

    GitCommitsByBranch(@NotNull Map<GitBranch, GitPushBranchInfo> commitsByBranch) {
        if (commitsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitCommitsByBranch", "<init>"));
        }
        this.myCommitsByBranch = new HashMap<GitBranch, GitPushBranchInfo>(commitsByBranch);
    }

    GitCommitsByBranch(GitCommitsByBranch commitsByBranch) {
        this(new HashMap<GitBranch, GitPushBranchInfo>(commitsByBranch.myCommitsByBranch));
    }

    boolean isEmpty() {
        for (GitPushBranchInfo info : this.myCommitsByBranch.values()) {
            if (info.isEmpty()) continue;
            return false;
        }
        return true;
    }

    int commitsNumber() {
        int sum = 0;
        for (GitPushBranchInfo branchInfo : this.myCommitsByBranch.values()) {
            sum += branchInfo.getCommits().size();
        }
        return sum;
    }

    @NotNull
    Collection<GitBranch> getBranches() {
        HashSet<GitBranch> hashSet = new HashSet<GitBranch>(this.myCommitsByBranch.keySet());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByBranch", "getBranches"));
        }
        return hashSet;
    }

    @NotNull
    GitPushBranchInfo get(@NotNull GitBranch branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitCommitsByBranch", "get"));
        }
        GitPushBranchInfo gitPushBranchInfo = new GitPushBranchInfo(this.myCommitsByBranch.get(branch));
        if (gitPushBranchInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByBranch", "get"));
        }
        return gitPushBranchInfo;
    }

    @NotNull
    GitCommitsByBranch retain(@NotNull GitBranch branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitCommitsByBranch", "retain"));
        }
        HashMap<GitBranch, GitPushBranchInfo> res = new HashMap<GitBranch, GitPushBranchInfo>();
        if (this.myCommitsByBranch.containsKey(branch)) {
            res.put(branch, this.myCommitsByBranch.get(branch));
        }
        GitCommitsByBranch gitCommitsByBranch = new GitCommitsByBranch(res);
        if (gitCommitsByBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByBranch", "retain"));
        }
        return gitCommitsByBranch;
    }

    @NotNull
    public Collection<GitCommit> getAllCommits() {
        ArrayList<GitCommit> commits = new ArrayList<GitCommit>();
        for (GitPushBranchInfo branchInfo : this.myCommitsByBranch.values()) {
            commits.addAll(branchInfo.getCommits());
        }
        ArrayList<GitCommit> arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitCommitsByBranch", "getAllCommits"));
        }
        return arrayList;
    }
}

