/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.log.GitRefManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefParser {
    private final VcsLogObjectsFactory myFactory;

    public RefParser(VcsLogObjectsFactory factory) {
        this.myFactory = factory;
    }

    public List<VcsRef> parseCommitRefs(@NotNull String input, @NotNull VirtualFile root) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/RefParser", "parseCommitRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/RefParser", "parseCommitRefs"));
        }
        int firstSpaceIndex = input.indexOf(32);
        if (firstSpaceIndex < 0) {
            return Collections.emptyList();
        }
        String strHash = input.substring(0, firstSpaceIndex);
        Hash hash = HashImpl.build((String)strHash);
        String refPaths = input.substring(firstSpaceIndex + 2, input.length() - 1);
        String[] longRefPaths = refPaths.split(", ");
        ArrayList<VcsRef> refs = new ArrayList<VcsRef>();
        for (String longRefPatch : longRefPaths) {
            VcsRef ref = this.createRef(hash, longRefPatch, root);
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    @Nullable
    private static String getRefName(@NotNull String longRefPath, @NotNull String startPatch) {
        if (longRefPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/RefParser", "getRefName"));
        }
        if (startPatch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/RefParser", "getRefName"));
        }
        String tagPrefix = "tag: ";
        if (longRefPath.startsWith(tagPrefix)) {
            longRefPath = longRefPath.substring(tagPrefix.length());
        }
        if (longRefPath.startsWith(startPatch)) {
            return longRefPath.substring(startPatch.length());
        }
        return null;
    }

    @Nullable
    private VcsRef createRef(@NotNull Hash hash, @NotNull String longRefPath, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/RefParser", "createRef"));
        }
        if (longRefPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/RefParser", "createRef"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/log/RefParser", "createRef"));
        }
        String name = RefParser.getRefName(longRefPath, "refs/tags/");
        if (name != null) {
            return this.myFactory.createRef(hash, name, GitRefManager.TAG, root);
        }
        return null;
    }
}

