/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitRefManager
implements VcsLogRefManager {
    private static final Color HEAD_COLOR = new JBColor(new Color(15855518), new Color(113, 111, 64));
    private static final Color LOCAL_BRANCH_COLOR = new JBColor(new Color(7728839), new Color(879951));
    private static final Color REMOTE_BRANCH_COLOR = new JBColor(new Color(0xBCBCFC), new Color(0xBCBCFC).darker().darker());
    private static final Color TAG_COLOR = JBColor.WHITE;
    public static final VcsRefType HEAD = new SimpleRefType(true, HEAD_COLOR);
    public static final VcsRefType LOCAL_BRANCH = new SimpleRefType(true, LOCAL_BRANCH_COLOR);
    public static final VcsRefType REMOTE_BRANCH = new SimpleRefType(true, REMOTE_BRANCH_COLOR);
    public static final VcsRefType TAG = new SimpleRefType(false, TAG_COLOR);
    private static final List<VcsRefType> REF_TYPE_PRIORITIES = Arrays.asList(HEAD, LOCAL_BRANCH, REMOTE_BRANCH, TAG);
    public static final Comparator<VcsRefType> REF_TYPE_COMPARATOR = new Comparator<VcsRefType>(){

        @Override
        public int compare(VcsRefType type1, VcsRefType type2) {
            int p1 = REF_TYPE_PRIORITIES.indexOf(type1);
            int p2 = REF_TYPE_PRIORITIES.indexOf(type2);
            return p1 - p2;
        }
    };
    private static final String MASTER = "master";
    private static final String ORIGIN_MASTER = "origin/master";
    private static final Logger LOG = Logger.getInstance(GitRefManager.class);
    @NotNull
    private final RepositoryManager<GitRepository> myRepositoryManager;
    private final Comparator<VcsRef> REF_COMPARATOR;

    private boolean hasTrackingBranch(final @NotNull VcsRef ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitRefManager", "hasTrackingBranch"));
        }
        GitRepository repo = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(ref.getRoot());
        if (repo == null) {
            LOG.error("Undefined root " + ref.getRoot());
            return false;
        }
        return ContainerUtil.find(repo.getBranchTrackInfos(), (Condition)new Condition<GitBranchTrackInfo>(){

            public boolean value(GitBranchTrackInfo info) {
                return info.getRemoteBranch().getNameForLocalOperations().equals(ref.getName());
            }
        }) != null;
    }

    public GitRefManager(@NotNull RepositoryManager<GitRepository> repositoryManager) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitRefManager", "<init>"));
        }
        this.REF_COMPARATOR = new Comparator<VcsRef>(){

            @Override
            public int compare(VcsRef ref1, VcsRef ref2) {
                VcsRefType type2;
                VcsRefType type1 = ref1.getType();
                int typeComparison = REF_TYPE_COMPARATOR.compare(type1, type2 = ref2.getType());
                if (typeComparison != 0) {
                    return typeComparison;
                }
                VcsRefType type = type1;
                if (type == LOCAL_BRANCH) {
                    if (ref1.getName().equals(GitRefManager.MASTER)) {
                        return -1;
                    }
                    if (ref2.getName().equals(GitRefManager.MASTER)) {
                        return 1;
                    }
                    return ref1.getName().compareTo(ref2.getName());
                }
                if (type == REMOTE_BRANCH) {
                    if (ref1.getName().equals(GitRefManager.ORIGIN_MASTER)) {
                        return -1;
                    }
                    if (ref2.getName().equals(GitRefManager.ORIGIN_MASTER)) {
                        return 1;
                    }
                    if (GitRefManager.this.hasTrackingBranch(ref1) && !GitRefManager.this.hasTrackingBranch(ref2)) {
                        return -1;
                    }
                    if (!GitRefManager.this.hasTrackingBranch(ref1) && GitRefManager.this.hasTrackingBranch(ref2)) {
                        return 1;
                    }
                    return ref1.getName().compareTo(ref2.getName());
                }
                return ref1.getName().compareTo(ref2.getName());
            }
        };
        this.myRepositoryManager = repositoryManager;
    }

    @NotNull
    public List<VcsRef> sort(Collection<VcsRef> refs) {
        ArrayList<VcsRef> list = new ArrayList<VcsRef>(refs);
        Collections.sort(list, this.REF_COMPARATOR);
        ArrayList<VcsRef> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "sort"));
        }
        return arrayList;
    }

    @NotNull
    public List<RefGroup> group(Collection<VcsRef> refs) {
        ArrayList simpleGroups = ContainerUtil.newArrayList();
        ArrayList localBranches = ContainerUtil.newArrayList();
        ArrayList trackedBranches = ContainerUtil.newArrayList();
        MultiMap remoteRefGroups = MultiMap.create();
        MultiMap<VirtualFile, VcsRef> refsByRoot = GitRefManager.groupRefsByRoot(refs);
        for (Map.Entry entry : refsByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            Collection refsInRoot = (Collection)entry.getValue();
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("No repository for root: " + root);
                continue;
            }
            Set<String> locals = GitRefManager.getLocalBranches(repository);
            Set<String> tracked = GitRefManager.getTrackedRemoteBranches(repository);
            Map<String, GitRemote> nonTracked = GitRefManager.getNonTrackedRemoteBranches(repository);
            for (VcsRef ref : refsInRoot) {
                if (ref.getType() == HEAD) {
                    simpleGroups.add(new SingletonRefGroup(ref));
                    continue;
                }
                String refName = ref.getName();
                if (locals.contains(refName)) {
                    localBranches.add(ref);
                    continue;
                }
                if (tracked.contains(refName)) {
                    trackedBranches.add(ref);
                    continue;
                }
                if (nonTracked.containsKey(refName)) {
                    remoteRefGroups.putValue((Object)nonTracked.get(refName), (Object)ref);
                    continue;
                }
                LOG.warn("Didn't find ref neither in local nor in remote branches: " + ref);
            }
        }
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(simpleGroups);
        result.add(new LogicalRefGroup("Local", localBranches));
        result.add(new LogicalRefGroup("Tracked", trackedBranches));
        for (Map.Entry entry : remoteRefGroups.entrySet()) {
            GitRemote remote = (GitRemote)entry.getKey();
            Collection branches = (Collection)entry.getValue();
            result.add(new RemoteRefGroup(remote, branches));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "group"));
        }
        return arrayList;
    }

    private static Set<String> getLocalBranches(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranches().getLocalBranches(), (Function)new Function<GitBranch, String>(){

            public String fun(GitBranch branch) {
                return branch.getName();
            }
        });
    }

    @NotNull
    private static Set<String> getTrackedRemoteBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitRefManager", "getTrackedRemoteBranches"));
        }
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashSet<String> tracked = new HashSet<String>();
        for (GitBranchTrackInfo info : repository.getBranchTrackInfos()) {
            GitRemoteBranch trackedRemoteBranch = info.getRemoteBranch();
            if (!all.contains(trackedRemoteBranch)) continue;
            tracked.add(trackedRemoteBranch.getName());
        }
        HashSet<String> hashSet = tracked;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getTrackedRemoteBranches"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, GitRemote> getNonTrackedRemoteBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitRefManager", "getNonTrackedRemoteBranches"));
        }
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        Set<String> tracked = GitRefManager.getTrackedRemoteBranchesFromConfig(repository);
        HashMap nonTracked = ContainerUtil.newHashMap();
        for (GitRemoteBranch remoteBranch : all) {
            if (tracked.contains(remoteBranch.getName())) continue;
            nonTracked.put(remoteBranch.getName(), remoteBranch.getRemote());
        }
        HashMap hashMap = nonTracked;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getNonTrackedRemoteBranches"));
        }
        return hashMap;
    }

    private static Set<String> getTrackedRemoteBranchesFromConfig(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranchTrackInfos(), (Function)new Function<GitBranchTrackInfo, String>(){

            public String fun(GitBranchTrackInfo trackInfo) {
                return trackInfo.getRemoteBranch().getName();
            }
        });
    }

    @NotNull
    private static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Iterable<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitRefManager", "groupRefsByRoot"));
        }
        MultiMap grouped = MultiMap.create();
        for (VcsRef ref : refs) {
            grouped.putValue((Object)ref.getRoot(), (Object)ref);
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "groupRefsByRoot"));
        }
        return multiMap;
    }

    private class RemoteRefGroup
    implements RefGroup {
        private final GitRemote myRemote;
        private final Collection<VcsRef> myBranches;

        public RemoteRefGroup(GitRemote remote, Collection<VcsRef> branches) {
            this.myRemote = remote;
            this.myBranches = branches;
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.myRemote.getName() + "/...";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getName"));
            }
            return string;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List<VcsRef> list = GitRefManager.this.sort(this.myBranches);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getRefs"));
            }
            return list;
        }

        @NotNull
        public Color getBgColor() {
            Color color = REMOTE_BRANCH_COLOR;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getBgColor"));
            }
            return color;
        }
    }

    private static class LogicalRefGroup
    implements RefGroup {
        private final String myGroupName;
        private final List<VcsRef> myRefs;

        private LogicalRefGroup(String groupName, List<VcsRef> refs) {
            this.myGroupName = groupName;
            this.myRefs = refs;
        }

        public boolean isExpanded() {
            return true;
        }

        @NotNull
        public String getName() {
            String string = this.myGroupName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getName"));
            }
            return string;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List<VcsRef> list = this.myRefs;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getRefs"));
            }
            return list;
        }

        @NotNull
        public Color getBgColor() {
            Color color = HEAD_COLOR;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getBgColor"));
            }
            return color;
        }
    }

    private static class SimpleRefType
    implements VcsRefType {
        private final boolean myIsBranch;
        @NotNull
        private final Color myColor;

        public SimpleRefType(boolean isBranch, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitRefManager$SimpleRefType", "<init>"));
            }
            this.myIsBranch = isBranch;
            this.myColor = color;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        @NotNull
        public Color getBackgroundColor() {
            Color color = this.myColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$SimpleRefType", "getBackgroundColor"));
            }
            return color;
        }
    }
}

