/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.log.GitRefManager;
import git4idea.log.RefParser;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(GitLogProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public GitLogProvider(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/log/GitLogProvider", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myRefSorter = new GitRefManager((RepositoryManager<GitRepository>)this.myRepositoryManager);
        this.myVcsObjectsFactory = factory;
    }

    @NotNull
    public List<? extends VcsCommitMetadata> readFirstBlock(@NotNull VirtualFile root, boolean ordered, int commitCount) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        if (!this.isRepositoryReady(root)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFirstBlock"));
            }
            return list;
        }
        Object[] params = ArrayUtil.mergeArrays((String[])ArrayUtil.toStringArray(GitHistoryUtils.LOG_ALL), (String[])new String[]{"--encoding=UTF-8", "--full-history", "--sparse", "--max-count=" + commitCount});
        if (ordered) {
            params = (String[])ArrayUtil.append((Object[])params, (Object)"--date-order");
        }
        List<? extends VcsCommitMetadata> list = GitHistoryUtils.loadMetadata(this.myProject, root, (String[])params);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        return list;
    }

    @NotNull
    public List<TimedVcsCommit> readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<VcsUser> userRegistry) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        if (!this.isRepositoryReady(root)) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllHashes"));
            }
            return list;
        }
        ArrayList<String> parameters = new ArrayList<String>(GitHistoryUtils.LOG_ALL);
        parameters.add("--sparse");
        List<TimedVcsCommit> list = GitHistoryUtils.readCommits(this.myProject, root, userRegistry, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        return list;
    }

    @NotNull
    public List<? extends VcsShortCommitDetails> readShortDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        List<? extends VcsShortCommitDetails> list = GitHistoryUtils.readMiniDetails(this.myProject, root, hashes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        return list;
    }

    @NotNull
    public List<? extends VcsFullCommitDetails> readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        List<GitCommit> list = GitHistoryUtils.commitsDetails(this.myProject, root, hashes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        return list;
    }

    @NotNull
    public Collection<VcsRef> readAllRefs(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "readAllRefs"));
        }
        if (!this.isRepositoryReady(root)) {
            List<VcsRef> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllRefs"));
            }
            return list;
        }
        GitRepository repository = this.getRepository(root);
        repository.update();
        Collection<GitLocalBranch> localBranches = repository.getBranches().getLocalBranches();
        Collection<GitRemoteBranch> remoteBranches = repository.getBranches().getRemoteBranches();
        ArrayList<VcsRef> refs = new ArrayList<VcsRef>(localBranches.size() + remoteBranches.size());
        for (GitLocalBranch localBranch : localBranches) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)localBranch.getHash()), localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
        }
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)remoteBranch.getHash()), remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
        }
        refs.addAll(this.readTags(root));
        ArrayList<VcsRef> arrayList = refs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllRefs"));
        }
        return arrayList;
    }

    private Collection<? extends VcsRef> readTags(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "readTags"));
        }
        GitSimpleHandler tagHandler = new GitSimpleHandler(this.myProject, root, GitCommand.LOG);
        tagHandler.setSilent(true);
        tagHandler.addParameters("--tags", "--no-walk", "--format=%H%d%x01", "--decorate=full");
        String out = tagHandler.run();
        ArrayList<VcsRef> refs = new ArrayList<VcsRef>();
        try {
            for (String record : out.split("\u0001")) {
                if (StringUtil.isEmptyOrSpaces((String)record)) continue;
                refs.addAll(new RefParser(this.myVcsObjectsFactory).parseCommitRefs(record.trim(), root));
            }
        }
        catch (Exception e) {
            LOG.error("Error during tags parsing", new Attachment[]{new Attachment("stack_trace.txt", ExceptionUtil.getThrowableText((Throwable)e)), new Attachment("git_output.txt", out)});
        }
        return refs;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getSupportedVcs"));
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getReferenceManager"));
        }
        return vcsLogRefManager;
    }

    public void subscribeToRootRefreshEvents(final @NotNull Collection<VirtualFile> roots, final @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "subscribeToRootRefreshEvents"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitLogProvider", "subscribeToRootRefreshEvents"));
        }
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider$1", "repositoryChanged"));
                }
                VirtualFile root = repository.getRoot();
                if (roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        if (!this.isRepositoryReady(root)) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
            }
            return list;
        }
        ArrayList filterParameters = ContainerUtil.newArrayList();
        if (filterCollection.getBranchFilter() != null) {
            GitRepository repository = this.getRepository(root);
            assert (repository != null) : "repository is null for root " + root + " but was previously reported as 'ready'";
            boolean atLeastOneBranchExists = false;
            for (String branchName : filterCollection.getBranchFilter().getBranchNames()) {
                if (!branchName.equals("HEAD") && repository.getBranches().findBranchByName(branchName) == null) continue;
                filterParameters.add(branchName);
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
                }
                return list;
            }
        } else {
            filterParameters.addAll(GitHistoryUtils.LOG_ALL);
        }
        if (filterCollection.getUserFilter() != null) {
            String authorFilter = StringUtil.join((Collection)filterCollection.getUserFilter().getUserNames(root), (String)"|");
            filterParameters.add(GitLogProvider.prepareParameter("author", StringUtil.escapeChar((String)StringUtil.escapeBackSlashes((String)authorFilter), (char)'|')));
        }
        if (filterCollection.getDateFilter() != null) {
            VcsLogDateFilter filter = filterCollection.getDateFilter();
            if (filter.getAfter() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("after", filter.getAfter().toString()));
            }
            if (filter.getBefore() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("before", filter.getBefore().toString()));
            }
        }
        if (filterCollection.getTextFilter() != null) {
            String textFilter = StringUtil.escapeBackSlashes((String)filterCollection.getTextFilter().getText());
            filterParameters.add(GitLogProvider.prepareParameter("grep", textFilter));
        }
        filterParameters.add("--regexp-ignore-case");
        if (maxCount > 0) {
            filterParameters.add(GitLogProvider.prepareParameter("max-count", String.valueOf(maxCount)));
        }
        filterParameters.add("--date-order");
        if (filterCollection.getStructureFilter() != null) {
            filterParameters.add("--simplify-merges");
            filterParameters.add("--");
            for (VirtualFile file : filterCollection.getStructureFilter().getFiles(root)) {
                filterParameters.add(file.getPath());
            }
        }
        List<TimedVcsCommit> list = GitHistoryUtils.readCommits(this.myProject, root, (Consumer<VcsUser>)Consumer.EMPTY_CONSUMER, filterParameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        return list;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "getCurrentUser"));
        }
        String userName = GitConfigUtil.getValue(this.myProject, root, "user.name");
        String userEmail = StringUtil.notNullize((String)GitConfigUtil.getValue(this.myProject, root, "user.email"));
        return userName == null ? null : this.myVcsObjectsFactory.createUser(userName, userEmail);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        Collection<String> collection = GitBranchUtil.getBranches(this.myProject, root, true, true, commitHash.asString());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        return collection;
    }

    public boolean supportsFastUnorderedCommits() {
        return true;
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "getRepository"));
        }
        this.myRepositoryManager.waitUntilInitialized();
        return (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
    }

    private boolean isRepositoryReady(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitLogProvider", "isRepositoryReady"));
        }
        GitRepository repository = this.getRepository(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return false;
        }
        if (repository.isFresh()) {
            LOG.info("Fresh repository: " + root);
            return false;
        }
        return true;
    }
}

