/*
 * Decompiled with CFR 0.152.
 */
package git4idea.jgit;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import git4idea.jgit.GitHttpCredentialsProvider;
import git4idea.push.GitSimplePushResult;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface GitHttpRemoteCommand {
    public String getUrl();

    public void setUrl(String var1);

    public void run() throws GitAPIException, URISyntaxException, TransportException;

    public void cleanup();

    public GitHttpCredentialsProvider getCredentialsProvider();

    public String getLogString();

    public String getCommandString();

    public static class LsRemote
    implements GitHttpRemoteCommand {
        private final Git myGit;
        private final GitHttpCredentialsProvider myCredentialsProvider;
        private String myUrl;
        private Collection<Ref> myResultRefs;

        public LsRemote(@NotNull Git git, @NotNull GitHttpCredentialsProvider credentialsProvider, @NotNull String url) {
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$LsRemote", "<init>"));
            }
            if (credentialsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpRemoteCommand$LsRemote", "<init>"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/jgit/GitHttpRemoteCommand$LsRemote", "<init>"));
            }
            this.myGit = git;
            this.myCredentialsProvider = credentialsProvider;
            this.myUrl = url;
        }

        @Override
        public void run() throws InvalidRemoteException, TransportException {
            this.myResultRefs = this.call();
        }

        @Override
        public void cleanup() {
        }

        @Override
        public GitHttpCredentialsProvider getCredentialsProvider() {
            return this.myCredentialsProvider;
        }

        @Override
        public String getLogString() {
            return this.getCommandString();
        }

        @Override
        public String getCommandString() {
            return String.format("git ls-remote --heads %s ", this.myUrl);
        }

        @Override
        public String getUrl() {
            return this.myUrl;
        }

        @Override
        public void setUrl(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$LsRemote", "setUrl"));
            }
            this.myUrl = url;
        }

        @NotNull
        public Collection<Ref> getRefs() {
            Collection<Object> collection = this.myResultRefs == null ? Collections.emptyList() : this.myResultRefs;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpRemoteCommand$LsRemote", "getRefs"));
            }
            return collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Collection<Ref> call() throws TransportException, InvalidRemoteException {
            try {
                Transport transport = Transport.open((Repository)this.myGit.getRepository(), (String)this.myUrl);
                try {
                    ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>(1);
                    refSpecs.add(new RefSpec("refs/heads/*:refs/remotes/origin/*"));
                    HashMap<String, Ref> refmap = new HashMap<String, Ref>();
                    transport.setCredentialsProvider((CredentialsProvider)this.myCredentialsProvider);
                    FetchConnection fc = transport.openFetch();
                    try {
                        Collection refs = fc.getRefs();
                        if (refSpecs.isEmpty()) {
                            for (Ref r : refs) {
                                refmap.put(r.getName(), r);
                            }
                        } else {
                            block12: for (Ref r : refs) {
                                for (RefSpec rs : refSpecs) {
                                    if (!rs.matchSource(r)) continue;
                                    refmap.put(r.getName(), r);
                                    continue block12;
                                }
                            }
                        }
                    }
                    finally {
                        fc.close();
                    }
                    Collection<Ref> collection = refmap.values();
                    return collection;
                }
                catch (TransportException e) {
                    throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfLsRemoteCommand, (Throwable)e);
                }
                finally {
                    transport.close();
                }
            }
            catch (URISyntaxException e) {
                throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.myUrl));
            }
            catch (NotSupportedException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfLsRemoteCommand, (Throwable)e);
            }
        }
    }

    public static class Push
    implements GitHttpRemoteCommand {
        private final Git myGit;
        private final GitHttpCredentialsProvider myCredentialsProvider;
        private GitSimplePushResult myPushResult;
        private String myRemoteName;
        private String myUrl;
        private final List<RefSpec> myPushSpecs;

        Push(@NotNull Git git, @NotNull GitHttpCredentialsProvider credentialsProvider, @NotNull String remoteName, @NotNull String url, @NotNull List<RefSpec> pushSpecs) {
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Push", "<init>"));
            }
            if (credentialsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpRemoteCommand$Push", "<init>"));
            }
            if (remoteName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/jgit/GitHttpRemoteCommand$Push", "<init>"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/jgit/GitHttpRemoteCommand$Push", "<init>"));
            }
            if (pushSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/jgit/GitHttpRemoteCommand$Push", "<init>"));
            }
            this.myGit = git;
            this.myCredentialsProvider = credentialsProvider;
            this.myRemoteName = remoteName;
            this.myUrl = url;
            this.myPushSpecs = pushSpecs;
        }

        @Override
        public void run() throws InvalidRemoteException, URISyntaxException, org.eclipse.jgit.api.errors.TransportException {
            PushCommand pushCommand = this.myGit.push();
            pushCommand.setRemote(this.myRemoteName);
            pushCommand.setRefSpecs(this.myPushSpecs);
            pushCommand.setCredentialsProvider((CredentialsProvider)this.myCredentialsProvider);
            RemoteConfig rc = new RemoteConfig((Config)this.myGit.getRepository().getConfig(), this.myRemoteName);
            ArrayList uris = new ArrayList(rc.getURIs());
            for (URIish uri : uris) {
                rc.removeURI(uri);
            }
            uris = new ArrayList(rc.getPushURIs());
            for (URIish uri : uris) {
                rc.removePushURI(uri);
            }
            rc.addPushURI(new URIish(this.myUrl));
            Iterable<PushResult> results = this.call(pushCommand, rc);
            this.myPushResult = Push.analyzeResults(results);
        }

        @Override
        public void setUrl(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Push", "setUrl"));
            }
            this.myUrl = url;
        }

        @Override
        public String getUrl() {
            return this.myUrl;
        }

        @Override
        public GitHttpCredentialsProvider getCredentialsProvider() {
            return this.myCredentialsProvider;
        }

        @Override
        public String getLogString() {
            return String.format("git push %s (%s) %s", this.myRemoteName, this.myUrl, Fetch.getRefspecsAsString(this.myPushSpecs));
        }

        @Override
        public String getCommandString() {
            return String.format("git push %s %s", this.myRemoteName, Fetch.getRefspecsAsString(this.myPushSpecs));
        }

        @Override
        public void cleanup() {
        }

        @Nullable
        GitSimplePushResult getResult() {
            return this.myPushResult;
        }

        @NotNull
        private static GitSimplePushResult analyzeResults(@NotNull Iterable<PushResult> results) {
            if (results == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Push", "analyzeResults"));
            }
            ArrayList<String> rejectedBranches = new ArrayList<String>();
            StringBuilder errorReport = new StringBuilder();
            for (PushResult result : results) {
                for (RemoteRefUpdate update : result.getRemoteUpdates()) {
                    switch (update.getStatus()) {
                        case REJECTED_NONFASTFORWARD: {
                            rejectedBranches.add(update.getSrcRef());
                        }
                        case NON_EXISTING: 
                        case REJECTED_NODELETE: 
                        case REJECTED_OTHER_REASON: 
                        case REJECTED_REMOTE_CHANGED: {
                            errorReport.append(update.getSrcRef() + ": " + update.getStatus() + "<br/>");
                        }
                    }
                }
            }
            if (!rejectedBranches.isEmpty()) {
                GitSimplePushResult gitSimplePushResult = GitSimplePushResult.reject(rejectedBranches);
                if (gitSimplePushResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpRemoteCommand$Push", "analyzeResults"));
                }
                return gitSimplePushResult;
            }
            if (errorReport.toString().isEmpty()) {
                GitSimplePushResult gitSimplePushResult = GitSimplePushResult.success();
                if (gitSimplePushResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpRemoteCommand$Push", "analyzeResults"));
                }
                return gitSimplePushResult;
            }
            GitSimplePushResult gitSimplePushResult = GitSimplePushResult.error(errorReport.toString());
            if (gitSimplePushResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpRemoteCommand$Push", "analyzeResults"));
            }
            return gitSimplePushResult;
        }

        @NotNull
        private Iterable<PushResult> call(PushCommand pushCommand, RemoteConfig remoteConfig) throws JGitInternalException, InvalidRemoteException, org.eclipse.jgit.api.errors.TransportException {
            ArrayList<PushResult> pushResults = new ArrayList<PushResult>(3);
            List refSpecs = pushCommand.getRefSpecs();
            Repository repo = pushCommand.getRepository();
            boolean force = pushCommand.isForce();
            int timeout = pushCommand.getTimeout();
            GitHttpCredentialsProvider credentialsProvider = this.myCredentialsProvider;
            String receivePack = pushCommand.getReceivePack();
            boolean thin = pushCommand.isThin();
            boolean dryRun = pushCommand.isDryRun();
            String remote = pushCommand.getRemote();
            ProgressMonitor monitor = pushCommand.getProgressMonitor();
            try {
                Ref head;
                if (refSpecs.isEmpty()) {
                    RemoteConfig config = new RemoteConfig((Config)repo.getConfig(), pushCommand.getRemote());
                    refSpecs.addAll(config.getPushRefSpecs());
                }
                if (refSpecs.isEmpty() && (head = repo.getRef("HEAD")) != null && head.isSymbolic()) {
                    refSpecs.add(new RefSpec(head.getLeaf().getName()));
                }
                if (force) {
                    for (int i = 0; i < refSpecs.size(); ++i) {
                        refSpecs.set(i, ((RefSpec)refSpecs.get(i)).setForceUpdate(true));
                    }
                }
                List transports = Transport.openAll((Repository)repo, (RemoteConfig)remoteConfig, (Transport.Operation)Transport.Operation.PUSH);
                for (Transport transport : transports) {
                    if (0 <= timeout) {
                        transport.setTimeout(timeout);
                    }
                    transport.setPushThin(thin);
                    if (receivePack != null) {
                        transport.setOptionReceivePack(receivePack);
                    }
                    transport.setDryRun(dryRun);
                    if (credentialsProvider != null) {
                        transport.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                    }
                    Collection toPush = transport.findRemoteRefUpdatesFor((Collection)refSpecs);
                    try {
                        PushResult result = transport.push(monitor, toPush);
                        pushResults.add(result);
                    }
                    catch (TransportException e) {
                        throw new org.eclipse.jgit.api.errors.TransportException(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        transport.close();
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, remote));
            }
            catch (TransportException e) {
                throw new org.eclipse.jgit.api.errors.TransportException(e.getMessage(), (Throwable)e);
            }
            catch (NotSupportedException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, (Throwable)e);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, (Throwable)e);
            }
            ArrayList<PushResult> arrayList = pushResults;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpRemoteCommand$Push", "call"));
            }
            return arrayList;
        }
    }

    public static class Clone
    implements GitHttpRemoteCommand {
        private final File myTargetDirectory;
        private final GitHttpCredentialsProvider myCredentialsProvider;
        private String myUrl;
        @Nullable
        private Git myGit;

        Clone(@NotNull File targetDirectory, @NotNull GitHttpCredentialsProvider credentialsProvider, String url) {
            if (targetDirectory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Clone", "<init>"));
            }
            if (credentialsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpRemoteCommand$Clone", "<init>"));
            }
            this.myTargetDirectory = targetDirectory;
            this.myCredentialsProvider = credentialsProvider;
            this.myUrl = url;
        }

        @Override
        public void run() throws GitAPIException {
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setDirectory(this.myTargetDirectory);
            cloneCommand.setURI(this.myUrl);
            cloneCommand.setCredentialsProvider((CredentialsProvider)this.myCredentialsProvider);
            this.myGit = cloneCommand.call();
        }

        @Override
        public void setUrl(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Clone", "setUrl"));
            }
            this.myUrl = url;
        }

        @Override
        public String getUrl() {
            return this.myUrl;
        }

        @Override
        public GitHttpCredentialsProvider getCredentialsProvider() {
            return this.myCredentialsProvider;
        }

        @Override
        public String getLogString() {
            return this.getCommandString();
        }

        @Override
        public String getCommandString() {
            return String.format("git clone %s %s", this.myUrl, this.myTargetDirectory.getPath());
        }

        @Override
        public void cleanup() {
            if (this.myTargetDirectory.exists()) {
                FileUtil.delete((File)this.myTargetDirectory);
            }
        }

        @Nullable
        public Git getGit() {
            return this.myGit;
        }
    }

    public static class Fetch
    implements GitHttpRemoteCommand {
        private final Git myGit;
        private final GitHttpCredentialsProvider myCredentialsProvider;
        private String myUrl;
        private final List<RefSpec> myRefSpecs;

        Fetch(@NotNull Git git, @NotNull GitHttpCredentialsProvider credentialsProvider, @NotNull String url, @NotNull List<RefSpec> refSpecs) {
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Fetch", "<init>"));
            }
            if (credentialsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpRemoteCommand$Fetch", "<init>"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/jgit/GitHttpRemoteCommand$Fetch", "<init>"));
            }
            if (refSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/jgit/GitHttpRemoteCommand$Fetch", "<init>"));
            }
            this.myGit = git;
            this.myCredentialsProvider = credentialsProvider;
            this.myUrl = url;
            this.myRefSpecs = refSpecs;
        }

        @Override
        public void run() throws GitAPIException {
            FetchCommand fetchCommand = this.myGit.fetch();
            fetchCommand.setRemote(this.myUrl);
            fetchCommand.setRefSpecs(this.myRefSpecs);
            fetchCommand.setCredentialsProvider((CredentialsProvider)this.myCredentialsProvider);
            fetchCommand.call();
        }

        @Override
        public void setUrl(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Fetch", "setUrl"));
            }
            this.myUrl = url;
        }

        @Override
        public String getUrl() {
            return this.myUrl;
        }

        @Override
        public GitHttpCredentialsProvider getCredentialsProvider() {
            return this.myCredentialsProvider;
        }

        @Override
        public String getLogString() {
            return this.getCommandString();
        }

        @Override
        public String getCommandString() {
            return String.format("git fetch %s %s", this.myUrl, Fetch.getRefspecsAsString(this.myRefSpecs));
        }

        static String getRefspecsAsString(@NotNull List<RefSpec> refSpecs) {
            if (refSpecs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpRemoteCommand$Fetch", "getRefspecsAsString"));
            }
            return StringUtil.join(refSpecs, (Function)new Function<RefSpec, String>(){

                public String fun(RefSpec spec) {
                    return spec.toString();
                }
            }, (String)" ");
        }

        @Override
        public void cleanup() {
        }
    }
}

