/*
 * Decompiled with CFR 0.152.
 */
package git4idea.jgit;

import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.AuthDialog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHttpCredentialsProvider
extends CredentialsProvider {
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("http(?:s?)://(?:([\\S^@\\.]*)@)?.*");
    private final Project myProject;
    private String myRemoteUrl;
    private boolean myCancelled;
    private boolean myRememberPassword;
    private String myPassword;
    private String myUserName;
    private boolean myShowDialog;
    private boolean myDialogShown;

    public GitHttpCredentialsProvider(@NotNull Project project, @NotNull String remoteUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpCredentialsProvider", "<init>"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/jgit/GitHttpCredentialsProvider", "<init>"));
        }
        this.myProject = project;
        this.myRemoteUrl = remoteUrl;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.Password || item instanceof CredentialItem.Username) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        CredentialItem.Username userNameItem = null;
        CredentialItem.Password passwordItem = null;
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.Username) {
                userNameItem = (CredentialItem.Username)item;
                continue;
            }
            if (!(item instanceof CredentialItem.Password)) continue;
            passwordItem = (CredentialItem.Password)item;
        }
        if (userNameItem != null || passwordItem != null) {
            boolean ok;
            String username = GitHttpCredentialsProvider.getUserNameFromUrl(this.myRemoteUrl);
            String password = null;
            if (username == null) {
                username = this.myUserName;
                password = this.myPassword;
            } else if (username.equals(this.myUserName)) {
                password = this.myPassword;
            }
            boolean rememberPassword = this.myRememberPassword;
            if (username != null && password != null && !this.myShowDialog) {
                ok = true;
                this.myDialogShown = false;
            } else {
                final AuthDialog dialog = new AuthDialog(this.myProject, "Login required", "Login to " + this.myRemoteUrl, username, password, false);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        dialog.show();
                    }
                });
                ok = dialog.isOK();
                this.myDialogShown = true;
                if (ok) {
                    username = dialog.getUsername();
                    password = dialog.getPassword();
                    rememberPassword = dialog.isRememberPassword();
                }
            }
            if (ok) {
                if (userNameItem != null) {
                    userNameItem.setValue(username);
                }
                if (passwordItem != null) {
                    passwordItem.setValue(password.toCharArray());
                }
                this.myRememberPassword = rememberPassword;
                this.myPassword = password;
                this.myUserName = username;
            } else {
                this.myCancelled = true;
                this.myRememberPassword = false;
            }
            return ok;
        }
        return true;
    }

    public boolean isRememberPassword() {
        return this.myRememberPassword;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpCredentialsProvider", "getProject"));
        }
        return project;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    @Nullable
    public String getUserName() {
        return this.myUserName;
    }

    @NotNull
    public String getUrl() {
        String string = this.myRemoteUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/jgit/GitHttpCredentialsProvider", "getUrl"));
        }
        return string;
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpCredentialsProvider", "setUrl"));
        }
        this.myRemoteUrl = url;
    }

    public void fillAuthDataIfNotFilled(@NotNull String login, @Nullable String password) {
        if (login == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpCredentialsProvider", "fillAuthDataIfNotFilled"));
        }
        if (this.myUserName == null) {
            this.myUserName = login;
            this.myPassword = password;
        } else if (this.myPassword != null) {
            this.myPassword = password;
        }
    }

    public void setAlwaysShowDialog(boolean showDialog) {
        this.myShowDialog = showDialog;
    }

    public boolean wasDialogShown() {
        return this.myDialogShown;
    }

    @Nullable
    private static String getUserNameFromUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/jgit/GitHttpCredentialsProvider", "getUserNameFromUrl"));
        }
        Matcher matcher = HTTP_URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public boolean wasCancelled() {
        return this.myCancelled;
    }
}

