/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.util.Ref;
import git4idea.history.wholeTree.AssertProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UsersIndex {
    private boolean myIsDirty = false;
    private Map<String, Ref<Integer>> myIndex = new HashMap<String, Ref<Integer>>();
    private final List<String> myKeys = new ArrayList<String>();

    protected UsersIndex() {
    }

    public Read createRead() {
        return AssertProxy.createAWTAccess(new Read(this.myIsDirty, this.myIndex, this.myKeys));
    }

    public Collection<String> getKeys() {
        return Collections.unmodifiableSet(this.myIndex.keySet());
    }

    public Ref<Integer> put(String name) {
        if (!this.myIndex.containsKey(name)) {
            Ref ref = new Ref((Object)-1);
            if (this.myIsDirty) {
                this.myIndex.put(name, (Ref<Integer>)ref);
                return ref;
            }
            Map<String, Ref<Integer>> map = this.myIndex;
            this.myIndex = new HashMap<String, Ref<Integer>>();
            for (String s : this.myIndex.keySet()) {
                this.myIndex.put(s, map.get(s));
            }
            this.myIndex.put(name, (Ref<Integer>)ref);
            this.myIsDirty = true;
            return ref;
        }
        return this.myIndex.get(name);
    }

    public static class Read {
        private boolean myIsDirty;
        private final Map<String, Ref<Integer>> myIndex;
        private final List<String> myKeys;

        public Read(boolean isDirty, Map<String, Ref<Integer>> map, List<String> keys) {
            this.myIsDirty = isDirty;
            this.myIndex = map;
            this.myKeys = keys;
        }

        public void recalculate() {
            this.myKeys.clear();
            this.myKeys.addAll(this.myIndex.keySet());
            Collections.sort(this.myKeys);
            if (this.myIsDirty) {
                int i = 0;
                for (String key : this.myKeys) {
                    this.myIndex.get(key).set((Object)i);
                    ++i;
                }
                this.myIsDirty = false;
            }
        }

        public String getName(int idx) {
            return this.myKeys.get(idx);
        }

        public Ref<Integer> get(String name) {
            assert (!this.myIsDirty);
            return this.myIndex.get(name);
        }
    }
}

