/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import java.util.LinkedList;

public class Speedometer {
    private final int myHistorySize;
    private final int myMillisInterval;
    private final LinkedList<Long> myEvents;

    public Speedometer() {
        this(-1, -1);
    }

    public Speedometer(int historySize, int millisInterval) {
        this.myHistorySize = historySize == -1 ? 20 : historySize;
        this.myMillisInterval = millisInterval == -1 ? 500 : millisInterval;
        this.myEvents = new LinkedList();
    }

    public void event() {
        while (this.myEvents.size() >= this.myHistorySize) {
            this.myEvents.removeLast();
        }
        this.myEvents.addFirst(System.currentTimeMillis());
    }

    public double getSpeed() {
        long end;
        if (this.myEvents.isEmpty()) {
            return 0.0;
        }
        long current = System.currentTimeMillis();
        long boundary = current - (long)this.myMillisInterval;
        int cnt = 0;
        long last = end = this.myEvents.getFirst().longValue();
        for (Long event : this.myEvents) {
            if (cnt > this.myHistorySize || event < boundary) break;
            ++cnt;
            last = event;
        }
        if (cnt == 0) {
            return 0.0;
        }
        return ((double)end - (double)last) / (double)(cnt * 100);
    }

    public void clear() {
        this.myEvents.clear();
    }

    public boolean hasData() {
        return !this.myEvents.isEmpty();
    }
}

