/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.history.wholeTree.BigTableTableModel;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.DetailsLoaderImpl;
import git4idea.history.wholeTree.GitCommitsSequentially;
import git4idea.history.wholeTree.GitLog;
import git4idea.history.wholeTree.GitLogUI;
import git4idea.history.wholeTree.LoadController;
import git4idea.history.wholeTree.MediatorImpl;
import java.util.List;
import javax.swing.JComponent;

public class GitLogAssembler
implements GitLog {
    private final Project myProject;
    private final boolean myProjectScope;
    private GitLogUI myGitLogUI;
    private MediatorImpl myMediator;
    private DetailsLoaderImpl myDetailsLoader;
    private DetailsCache myDetailsCache;
    private LoadController myLoadController;
    private BigTableTableModel myTableModel;
    private boolean myInitialized;

    public GitLogAssembler(Project project, boolean projectScope, GitCommitsSequentially gitCommitsSequentially) {
        this.myProject = project;
        this.myProjectScope = projectScope;
        this.myMediator = new MediatorImpl(this.myProject, gitCommitsSequentially);
        this.myGitLogUI = new GitLogUI(this.myProject, this.myMediator);
        this.myTableModel = this.myGitLogUI.getTableModel();
        BackgroundTaskQueue queue = new BackgroundTaskQueue(project, "Git log details");
        this.myDetailsLoader = new DetailsLoaderImpl(this.myProject, queue);
        this.myDetailsCache = new DetailsCache(this.myProject, this.myGitLogUI.getUIRefresh(), this.myDetailsLoader, queue);
        this.myDetailsLoader.setDetailsCache(this.myDetailsCache);
        this.myGitLogUI.setDetailsCache(this.myDetailsCache);
        this.myGitLogUI.createMe();
        this.myGitLogUI.setProjectScope(projectScope);
        this.myLoadController = new LoadController(this.myProject, this.myMediator, this.myDetailsCache, gitCommitsSequentially);
        this.myMediator.setLoader(this.myLoadController);
        this.myMediator.setTableModel(this.myTableModel);
        this.myMediator.setUIRefresh(this.myGitLogUI.getRefreshObject());
        this.myMediator.setDetailsLoader(this.myDetailsLoader);
        this.myTableModel.setCache(this.myDetailsCache);
        Disposer.register((Disposable)this, (Disposable)this.myGitLogUI);
    }

    @Override
    public JComponent getVisualComponent() {
        return this.myGitLogUI.getPanel();
    }

    @Override
    public void setModalityState(ModalityState state) {
        this.myDetailsCache.setModalityState(state);
        this.myDetailsLoader.setModalityState(state);
    }

    @Override
    public void selectCommit(String commitId) {
        this.myGitLogUI.selectCommit(commitId);
    }

    @Override
    public void rootsChanged(List<VirtualFile> roots) {
        this.myGitLogUI.rootsChanged(roots);
        if (this.myProjectScope && !this.myInitialized) {
            this.myInitialized = true;
            this.myGitLogUI.initFromSettings();
        }
    }

    public void dispose() {
    }
}

