/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import git4idea.history.wholeTree.BasePopupAction;
import git4idea.history.wholeTree.DatesFilterI;
import git4idea.history.wholeTree.GitLogSettings;
import java.util.GregorianCalendar;
import javax.swing.JComponent;

public class DatesFilterAction
extends BasePopupAction {
    public static final String ALL = "All";
    public static final String DATES = "Date:";
    public static final String FILTER = "(filter)";
    public static final String TODAY = "Today";
    public static final String YESTERDAY = "Since Yesterday";
    private static final String WEEK = "Last Week";
    private static final String BEFORE_SELECTED = "Before ";
    private static final String AFTER_SELECTED = "After ";
    private static final String SELECT = "Select...";
    private final DumbAwareAction myAll;
    private final DatesFilterI myFilterI;
    private final DumbAwareAction myToday;
    private final DumbAwareAction myYesterday;
    private final DumbAwareAction myWeek;
    private final DumbAwareAction myBefore;
    private final DumbAwareAction myAfter;
    private final DumbAwareAction mySelect;

    public DatesFilterAction(Project project, DatesFilterI filterI) {
        super(project, DATES, "Date");
        this.myFilterI = filterI;
        this.myAll = new DumbAwareAction(ALL){

            public void actionPerformed(AnActionEvent e) {
                DatesFilterAction.this.myLabel.setText(DatesFilterAction.ALL);
                DatesFilterAction.this.myPanel.setToolTipText("Date: All");
                DatesFilterAction.this.myFilterI.selectAll();
            }
        };
        this.myToday = new DumbAwareAction(TODAY){

            public void actionPerformed(AnActionEvent e) {
                DatesFilterAction.this.myLabel.setText(DatesFilterAction.TODAY);
                DatesFilterAction.this.myPanel.setToolTipText("Date: Today");
                DatesFilterAction.this.myFilterI.filter(-1L, DatesFilterAction.this.getTodayMidnight(), DatesFilterAction.TODAY);
            }
        };
        this.myYesterday = new DumbAwareAction(YESTERDAY){

            public void actionPerformed(AnActionEvent e) {
                DatesFilterAction.this.myLabel.setText(DatesFilterAction.YESTERDAY);
                DatesFilterAction.this.myPanel.setToolTipText("Date: Since Yesterday");
                DatesFilterAction.this.myFilterI.filter(-1L, DatesFilterAction.this.yesterday(), DatesFilterAction.YESTERDAY);
            }
        };
        this.myWeek = new DumbAwareAction(WEEK){

            public void actionPerformed(AnActionEvent e) {
                DatesFilterAction.this.myLabel.setText(DatesFilterAction.WEEK);
                DatesFilterAction.this.myPanel.setToolTipText("Date: Last Week");
                DatesFilterAction.this.myFilterI.filter(-1L, DatesFilterAction.this.week(), DatesFilterAction.WEEK);
            }
        };
        this.myBefore = new DumbAwareAction(BEFORE_SELECTED){

            public void actionPerformed(AnActionEvent e) {
                long time = DatesFilterAction.this.myFilterI.getCommitTimeIfOne();
                if (time > 0L) {
                    DatesFilterAction.this.myFilterI.filter(time, DatesFilterAction.this.myFilterI.getAfter(), null);
                    String betweenText = DatesFilterAction.this.betweenText();
                    DatesFilterAction.this.myLabel.setText(DatesFilterAction.FILTER);
                    DatesFilterAction.this.myPanel.setToolTipText("Date: " + betweenText);
                }
            }

            public void update(AnActionEvent e) {
                long time = DatesFilterAction.this.myFilterI.getCommitTimeIfOne();
                Presentation presentation = e.getPresentation();
                presentation.setEnabledAndVisible(time > 0L);
                presentation.setText(DatesFilterAction.BEFORE_SELECTED + DateFormatUtil.formatDate((long)time));
            }
        };
        this.myAfter = new DumbAwareAction(AFTER_SELECTED){

            public void actionPerformed(AnActionEvent e) {
                long time = DatesFilterAction.this.myFilterI.getCommitTimeIfOne();
                if (time > 0L) {
                    DatesFilterAction.this.myFilterI.filter(DatesFilterAction.this.myFilterI.getBefore(), time, null);
                    String betweenText = DatesFilterAction.this.betweenText();
                    DatesFilterAction.this.myLabel.setText(DatesFilterAction.FILTER);
                    DatesFilterAction.this.myPanel.setToolTipText("Date: " + betweenText);
                }
            }

            public void update(AnActionEvent e) {
                long time = DatesFilterAction.this.myFilterI.getCommitTimeIfOne();
                Presentation presentation = e.getPresentation();
                presentation.setEnabledAndVisible(time > 0L);
                presentation.setText(DatesFilterAction.AFTER_SELECTED + DateFormatUtil.formatDate((long)time));
            }
        };
        this.mySelect = new DumbAwareAction(SELECT){

            public void actionPerformed(AnActionEvent e) {
                long after;
                final DateFilterComponent component = new DateFilterComponent(false, DateFormatUtil.getDateFormat().getDelegate());
                long before = DatesFilterAction.this.myFilterI.getBefore();
                if (before > 0L) {
                    component.setBefore(before);
                }
                if ((after = DatesFilterAction.this.myFilterI.getAfter()) > 0L) {
                    component.setAfter(after);
                }
                final DialogBuilder builder = new DialogBuilder(DatesFilterAction.this.myProject);
                builder.setTitle("Select Dates To Filter Between");
                builder.setOkActionEnabled(true);
                builder.setOkOperation(new Runnable(){

                    @Override
                    public void run() {
                        DatesFilterAction.this.myFilterI.filter(component.getBefore(), component.getAfter(), null);
                        String betweenText = DatesFilterAction.this.betweenText();
                        DatesFilterAction.this.myLabel.setText(DatesFilterAction.FILTER);
                        DatesFilterAction.this.myPanel.setToolTipText("Date: " + betweenText);
                        builder.getDialogWrapper().close(0);
                    }
                });
                builder.setCenterPanel((JComponent)component.getPanel());
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        builder.showModal(true);
                    }
                });
            }
        };
        this.myLabel.setText(ALL);
    }

    private String betweenText() {
        StringBuilder sb = new StringBuilder();
        if (this.myFilterI.isAll()) {
            return ALL;
        }
        long before = this.myFilterI.getBefore();
        long after = this.myFilterI.getAfter();
        if (before > 0L && after > 0L) {
            sb.append(DateFormatUtil.formatDate((long)after)).append(" - ").append(DateFormatUtil.formatDate((long)before));
        } else if (before > 0L) {
            sb.append(BEFORE_SELECTED).append(DateFormatUtil.formatDate((long)before));
        } else if (after > 0L) {
            sb.append(AFTER_SELECTED).append(DateFormatUtil.formatDate((long)after));
        }
        return sb.toString();
    }

    private long week() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(calendar.getTime().getTime() - 604800000L);
        this.onlyDate(calendar);
        return calendar.getTime().getTime();
    }

    private long yesterday() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(calendar.getTime().getTime() - 86400000L);
        this.onlyDate(calendar);
        return calendar.getTime().getTime();
    }

    private long getTodayMidnight() {
        GregorianCalendar calendar = new GregorianCalendar();
        this.onlyDate(calendar);
        return calendar.getTime().getTime();
    }

    private void onlyDate(GregorianCalendar calendar) {
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
    }

    @Override
    protected void createActions(Consumer<AnAction> actionConsumer) {
        actionConsumer.consume((Object)this.myAll);
        actionConsumer.consume((Object)this.myToday);
        actionConsumer.consume((Object)this.myYesterday);
        actionConsumer.consume((Object)this.myWeek);
        actionConsumer.consume((Object)this.mySelect);
        actionConsumer.consume((Object)this.myBefore);
        actionConsumer.consume((Object)this.myAfter);
    }

    public void setPreset(GitLogSettings.MyDateState state) {
        if (state.mySelectedTime) {
            if (state.myPresetFilter != null) {
                this.myLabel.setText(state.myPresetFilter);
                this.myPanel.setToolTipText("Date: " + state.myPresetFilter);
            } else {
                String betweenText = this.betweenText();
                this.myLabel.setText(FILTER);
                this.myPanel.setToolTipText("Date: " + betweenText);
            }
        }
    }
}

