/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.util.SmartList;
import git4idea.history.wholeTree.AbstractHash;
import java.util.List;

public class CommitHashPlusParents {
    private final AbstractHash myHash;
    private final long myTime;
    private final String[] myParents;
    private final String myAuthorName;

    public CommitHashPlusParents(AbstractHash hash, String[] parents, long time, String authorName) {
        this.myHash = hash;
        this.myParents = parents;
        this.myTime = time;
        this.myAuthorName = authorName;
    }

    public CommitHashPlusParents(String hash, String[] parents, long time, String authorName) {
        this.myHash = AbstractHash.create(hash);
        this.myParents = parents;
        this.myTime = time;
        this.myAuthorName = authorName;
    }

    public long getTime() {
        return this.myTime;
    }

    public String getHash() {
        return this.myHash.getString();
    }

    public AbstractHash getAbstractHash() {
        return this.myHash;
    }

    public List<AbstractHash> getParents() {
        SmartList result = new SmartList();
        for (String parent : this.myParents) {
            result.add((Object)AbstractHash.create(parent));
        }
        return result;
    }

    public String getAuthorName() {
        return this.myAuthorName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitHashPlusParents that = (CommitHashPlusParents)o;
        return this.myHash.equals(that.myHash);
    }

    public int hashCode() {
        return this.myHash.hashCode();
    }
}

