/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Ticket;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.history.browser.CachedRefs;
import git4idea.history.browser.ChangesFilter;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.LowLevelAccess;
import git4idea.history.browser.LowLevelAccessImpl;
import git4idea.history.browser.SHAHash;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.Commit;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.GitLogFilters;
import git4idea.history.wholeTree.LoaderAndRefresherImpl;
import git4idea.history.wholeTree.Mediator;
import git4idea.history.wholeTree.StepType;
import git4idea.history.wholeTree.UsersIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByRootLoader
extends TaskDescriptor {
    private final Project myProject;
    private final LoaderAndRefresherImpl.MyRootHolder myRootHolder;
    private final LowLevelAccess myLowLevelAccess;
    private final Mediator myMediator;
    private final DetailsCache myDetailsCache;
    private CachedRefs mySymbolicRefs;
    private final Ticket myTicket;
    private final UsersIndex myUsersIndex;
    private final Collection<String> myStartingPoints;
    @NotNull
    private final GitLogFilters myGitLogFilters;

    public ByRootLoader(Project project, LoaderAndRefresherImpl.MyRootHolder rootHolder, Mediator mediator, DetailsCache detailsCache, Ticket ticket, UsersIndex usersIndex, GitLogFilters gitLogFilters, Collection<String> startingPoints) {
        super("Initial checks", Where.POOLED);
        this.myProject = project;
        this.myRootHolder = rootHolder;
        this.myUsersIndex = usersIndex;
        this.myStartingPoints = startingPoints;
        this.myLowLevelAccess = new LowLevelAccessImpl(this.myProject, this.myRootHolder.getRoot());
        this.myMediator = mediator;
        this.myDetailsCache = detailsCache;
        this.myTicket = ticket;
        this.myGitLogFilters = gitLogFilters;
    }

    public void run(ContinuationContext context) {
        this.loadByHashesAside(context);
    }

    private void reportStashHead() {
        this.progress("Getting stash head");
        try {
            this.myMediator.acceptStashHead(this.myTicket, this.myRootHolder.getRoot(), GitHistoryUtils.getStashTop(this.myProject, this.myRootHolder.getRoot()));
        }
        catch (VcsException e) {
            this.myMediator.acceptException(e);
        }
    }

    private void progress(String progress) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText(progress);
        }
    }

    private void loadStash() {
        if (this.myStartingPoints != null && !this.myStartingPoints.isEmpty()) {
            return;
        }
        final ArrayList details = new ArrayList();
        final ArrayList<CommitI> commits = new ArrayList<CommitI>();
        final HashMap<AbstractHash, String> stashMap = new HashMap<AbstractHash, String>();
        final ArrayList<List<AbstractHash>> parents = !this.myGitLogFilters.haveDisordering() ? new ArrayList<List<AbstractHash>>() : null;
        this.myGitLogFilters.callConsumer(new Consumer<List<ChangesFilter.Filter>>(){

            public void consume(List<ChangesFilter.Filter> filters) {
                ProgressManager.checkCanceled();
                try {
                    ArrayList<String> parameters = new ArrayList<String>();
                    ArrayList<VirtualFile> paths = new ArrayList<VirtualFile>();
                    ChangesFilter.filtersToParameters(filters, parameters, paths);
                    List<Pair<String, GitHeavyCommit>> stash = GitHistoryUtils.loadStashStackAsCommits(ByRootLoader.this.myProject, ByRootLoader.this.myRootHolder.getRoot(), ByRootLoader.this.mySymbolicRefs, parameters.toArray(new String[parameters.size()]));
                    if (stash == null) {
                        return;
                    }
                    for (Pair<String, GitHeavyCommit> pair : stash) {
                        ProgressManager.checkCanceled();
                        GitHeavyCommit gitCommit = (GitHeavyCommit)pair.getSecond();
                        if (stashMap.containsKey(gitCommit.getShortHash())) continue;
                        details.add(gitCommit);
                        if (parents != null) {
                            parents.add(gitCommit.getConvertedParents());
                        }
                        commits.add(ByRootLoader.this.createCommitI(gitCommit));
                        stashMap.put(gitCommit.getShortHash(), pair.getFirst());
                    }
                }
                catch (VcsException e) {
                    ByRootLoader.this.myMediator.acceptException(e);
                }
            }
        }, true, this.myRootHolder.getRoot());
        this.myDetailsCache.putStash(this.myRootHolder.getRoot(), stashMap);
        ProgressManager.checkCanceled();
        this.myMediator.appendResult(this.myTicket, commits, parents, this.myRootHolder.getRoot(), false);
    }

    public void loadByHashesAside(ContinuationContext context) {
        StepType stepType;
        final ArrayList<CommitI> result = new ArrayList<CommitI>();
        final HashSet controlSet = new HashSet();
        final List<String> hashes = this.myGitLogFilters.getPossibleReferencies();
        if (hashes == null) {
            return;
        }
        this.progress("Try to load by reference");
        this.myGitLogFilters.callConsumer(new Consumer<List<ChangesFilter.Filter>>(){

            public void consume(List<ChangesFilter.Filter> filters) {
                for (String hash : hashes) {
                    try {
                        ChangesFilter.Filter filter;
                        List<GitHeavyCommit> commits;
                        SHAHash shaHash = GitChangeUtils.commitExists(ByRootLoader.this.myProject, ByRootLoader.this.myRootHolder.getRoot(), hash, Collections.<VirtualFile>emptyList(), new String[0]);
                        if (shaHash == null || controlSet.contains(shaHash)) continue;
                        controlSet.add(shaHash);
                        if (ByRootLoader.this.myStartingPoints != null && !ByRootLoader.this.myStartingPoints.isEmpty()) {
                            boolean matches = false;
                            for (String startingPoint : ByRootLoader.this.myStartingPoints) {
                                if (!GitChangeUtils.isAnyLevelChild(ByRootLoader.this.myProject, ByRootLoader.this.myRootHolder.getRoot(), shaHash, startingPoint)) continue;
                                matches = true;
                                break;
                            }
                            if (!matches) continue;
                        }
                        if ((commits = ByRootLoader.this.myLowLevelAccess.getCommitDetails(Collections.singletonList(shaHash.getValue()), ByRootLoader.this.mySymbolicRefs)).isEmpty()) continue;
                        assert (commits.size() == 1);
                        GitHeavyCommit commitDetails = commits.get(0);
                        boolean isOk = true;
                        Iterator<ChangesFilter.Filter> i$ = filters.iterator();
                        while (i$.hasNext() && (isOk = (filter = i$.next()).getMemoryFilter().applyInMemory(commitDetails))) {
                        }
                        if (!isOk) continue;
                        ByRootLoader.this.myDetailsCache.acceptAnswer(commits, ByRootLoader.this.myRootHolder.getRoot());
                        ByRootLoader.this.appendCommits(result, commits);
                    }
                    catch (VcsException e1) {}
                }
            }
        }, false, this.myRootHolder.getRoot());
        if (!result.isEmpty() && StepType.STOP.equals((Object)(stepType = this.myMediator.appendResult(this.myTicket, result, null, this.myRootHolder.getRoot(), true)))) {
            context.cancelEverything();
        }
    }

    private void appendCommits(List<CommitI> result, List<GitHeavyCommit> commits) {
        for (GitHeavyCommit commit : commits) {
            CommitI commitObj = this.createCommitI(commit);
            result.add(commitObj);
        }
    }

    private CommitI createCommitI(GitHeavyCommit commit) {
        CommitI commitObj = new Commit(commit.getShortHash().getString(), commit.getDate().getTime(), this.myUsersIndex.put(commit.getAuthor()));
        commitObj = this.myRootHolder.decorateByRoot(commitObj);
        return commitObj;
    }

    public CachedRefs initSymbRefs() {
        if (this.mySymbolicRefs == null) {
            try {
                this.mySymbolicRefs = this.myLowLevelAccess.getRefs();
                this.myMediator.reportSymbolicRefs(this.myTicket, this.myRootHolder.getRoot(), this.mySymbolicRefs);
            }
            catch (VcsException e) {
                this.myMediator.acceptException(e);
            }
        }
        return this.mySymbolicRefs;
    }

    public SymbolicRefsI getSymbolicRefs() {
        return this.mySymbolicRefs;
    }

    public LoaderAndRefresherImpl.MyRootHolder getRootHolder() {
        return this.myRootHolder;
    }
}

