/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.application.ApplicationManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AssertProxy<T> {
    private final T myProxy;
    private final T myVictim;
    private static final Runnable AWT_ASSERTION = new Runnable(){

        @Override
        public void run() {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
    };

    public static <T> T create(T victim, Runnable assertor) {
        return new AssertProxy<T>(victim, assertor).getProxy();
    }

    public static <T> T createAWTAccess(T victim) {
        return new AssertProxy<T>(victim, AWT_ASSERTION).getProxy();
    }

    private AssertProxy(T victim, final Runnable assertor) {
        this.myVictim = victim;
        Class<?> clazz = victim.getClass();
        assert (clazz.isInterface());
        this.myProxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                assertor.run();
                method.setAccessible(true);
                return method.invoke(AssertProxy.this.myVictim, args);
            }
        });
    }

    public T getProxy() {
        return this.myProxy;
    }
}

