/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.persistent.SmallMapSerializer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewGitUsersComponent {
    private final Object myLock = new Object();
    private SmallMapSerializer<String, List<String>> myState;
    private final File myFile;

    public NewGitUsersComponent(Project project) {
        File vcsFile = new File(PathManager.getSystemPath(), "vcs");
        File file = new File(vcsFile, "git_users_new");
        file.mkdirs();
        this.myFile = new File(file, project.getLocationHash());
    }

    public static NewGitUsersComponent getInstance(Project project) {
        return (NewGitUsersComponent)PeriodicalTasksCloser.getInstance().safeGetService(project, NewGitUsersComponent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> get() {
        Object object = this.myLock;
        synchronized (object) {
            List data = (List)this.myState.get((Object)"");
            return data == null ? null : Collections.unmodifiableList(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptUpdate(@NotNull Collection<String> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/NewGitUsersComponent", "acceptUpdate"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == null) {
                return;
            }
            List wasData = (List)this.myState.get((Object)"");
            if (wasData == null || !((Object)wasData).equals(data)) {
                HashSet<String> set = new HashSet<String>(data);
                if (wasData != null) {
                    set.addAll(wasData);
                }
                ArrayList<String> list = new ArrayList<String>(set);
                Collections.sort(list);
                this.myState.put((Object)"", list);
                this.myState.force();
            }
        }
    }

    public void activate() {
        this.myState = new SmallMapSerializer(this.myFile, (KeyDescriptor)new EnumeratorStringDescriptor(), NewGitUsersComponent.createExternalizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.myLock;
        synchronized (object) {
            this.myState.force();
            this.myState = null;
        }
    }

    private static DataExternalizer<List<String>> createExternalizer() {
        return new MyDataExternalizer();
    }

    private static class MyDataExternalizer
    implements DataExternalizer<List<String>> {
        private MyDataExternalizer() {
        }

        public List<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/NewGitUsersComponent$MyDataExternalizer", "read"));
            }
            int size = in.readInt();
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                result.add(in.readUTF());
            }
            return result;
        }

        public void save(@NotNull DataOutput out, List<String> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/NewGitUsersComponent$MyDataExternalizer", "save"));
            }
            out.writeInt(value.size());
            for (String s : value) {
                out.writeUTF(s);
            }
        }
    }
}

