/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogStatusInfo;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.SHAHash;
import git4idea.history.browser.SymbolicRefs;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.CommitHashPlusParents;
import git4idea.history.wholeTree.GitCommitsSequentialIndex;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    public static final List<String> LOG_ALL = Arrays.asList("HEAD", "--branches", "--remotes", "--tags");
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.GitHistoryUtils");

    private GitHistoryUtils() {
    }

    public static long getHeadTs(Project project, FilePath filePath) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters("HEAD");
        h.endOptions();
        String result = h.run();
        if (result.length() == 0) {
            return -1L;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return -1L;
        }
        record.setUsedHandler(h);
        return record.getDate().getTime();
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(Project project, FilePath filePath, @Nullable String branch) throws VcsException {
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        if (branch != null && !branch.isEmpty()) {
            h.addParameters(branch);
        } else {
            h.addParameters("--all");
        }
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        String author = Comparing.equal((String)record.getAuthorName(), (String)record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(Project project, FilePath filePath) throws VcsException {
        GitRemoteBranch t;
        VirtualFile root = GitUtil.getGitRoot(filePath);
        GitLocalBranch c = GitBranchUtil.getCurrentBranch(project, root);
        GitRemoteBranch gitRemoteBranch = t = c == null ? null : GitBranchUtil.tracked(project, root, c.getName());
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    public static void dumpFullHistory(Project project, VirtualFile root, String outFilePath) throws VcsException {
        if (!GitUtil.isGitRoot(new File(root.getPath()))) {
            throw new VcsException("Path " + root.getPath() + " is not git repository root");
        }
        final GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters(LOG_ALL);
        h.addParameters("--pretty=format:%H%x20%ct%x0A", "--date-order", "--reverse", "--encoding=UTF-8", "--full-history", "--sparse");
        h.endOptions();
        final OutputStream[] stream = new OutputStream[1];
        try {
            stream[0] = new BufferedOutputStream(new FileOutputStream(outFilePath, false));
            final Semaphore semaphore = new Semaphore();
            final VcsException[] ioExceptions = new VcsException[1];
            h.addLineListener(new GitLineHandlerListener(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (line.length() == 0) {
                        return;
                    }
                    try {
                        GitCommitsSequentialIndex.parseRecord(line);
                        stream[0].write((line + '\n').getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        ioExceptions[0] = new VcsException((Throwable)e);
                        h.cancel();
                        semaphore.up();
                    }
                    catch (ProcessCanceledException e) {
                        h.cancel();
                        semaphore.up();
                    }
                    catch (VcsException e) {
                        ioExceptions[0] = e;
                        h.cancel();
                        semaphore.up();
                    }
                }

                public void processTerminated(int exitCode) {
                    semaphore.up();
                }

                public void startFailed(Throwable exception) {
                    semaphore.up();
                }
            });
            semaphore.down();
            h.start();
            semaphore.waitFor();
            if (ioExceptions[0] != null) {
                throw ioExceptions[0];
            }
        }
        catch (FileNotFoundException e) {
            throw new VcsException((Throwable)e);
        }
        finally {
            try {
                if (stream[0] != null) {
                    stream[0].close();
                }
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }
        File file = new File(outFilePath);
        if (!file.exists() || file.length() == 0L) {
            throw new VcsException("Short repository history not loaded");
        }
    }

    public static void history(final Project project, FilePath path, @Nullable VirtualFile root, final Consumer<GitFileRevision> consumer, final Consumer<VcsException> exceptionConsumer, String ... parameters) {
        VirtualFile finalRoot;
        final FilePath filePath = GitHistoryUtils.getLastCommitName(project, path);
        try {
            finalRoot = root == null ? GitUtil.getGitRoot(filePath) : root;
        }
        catch (VcsException e) {
            exceptionConsumer.consume((Object)e);
            return;
        }
        GitLogParser logParser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        final AtomicReference<String> firstCommit = new AtomicReference<String>("HEAD");
        final AtomicReference<String> firstCommitParent = new AtomicReference<String>("HEAD");
        final AtomicReference<FilePath> currentPath = new AtomicReference<FilePath>(filePath);
        final AtomicReference<GitLineHandler> logHandler = new AtomicReference<GitLineHandler>();
        final AtomicBoolean skipFurtherOutput = new AtomicBoolean();
        Consumer<GitLogRecord> resultAdapter = new Consumer<GitLogRecord>(){

            public void consume(GitLogRecord record) {
                if (skipFurtherOutput.get()) {
                    return;
                }
                if (record == null) {
                    exceptionConsumer.consume((Object)new VcsException("revision details are null."));
                    return;
                }
                record.setUsedHandler((GitHandler)logHandler.get());
                GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
                firstCommit.set(record.getHash());
                String[] parentHashes = record.getParentsHashes();
                if (parentHashes == null || parentHashes.length < 1) {
                    firstCommitParent.set(null);
                } else {
                    firstCommitParent.set(parentHashes[0]);
                }
                String message = record.getFullMessage();
                try {
                    List<FilePath> paths = record.getFilePaths(finalRoot);
                    FilePath revisionPath = paths.size() > 0 ? paths.get(0) : (FilePath)currentPath.get();
                    Pair authorPair = Pair.create((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
                    Pair committerPair = record.getCommitterName() == null ? null : Pair.create((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
                    List<String> parents = parentHashes == null ? Collections.emptyList() : Arrays.asList(parentHashes);
                    consumer.consume((Object)new GitFileRevision(project, revisionPath, revision, (Pair<Pair<String, String>, Pair<String, String>>)Pair.create((Object)authorPair, (Object)committerPair), message, null, new Date(record.getAuthorTimeStamp()), parents));
                    List<GitLogStatusInfo> statusInfos = record.getStatusInfos();
                    if (statusInfos.isEmpty()) {
                        return;
                    }
                    if (statusInfos.get(0).getType() == GitChangeType.ADDED && !filePath.isDirectory()) {
                        skipFurtherOutput.set(true);
                    }
                }
                catch (VcsException e) {
                    exceptionConsumer.consume((Object)e);
                }
            }
        };
        AtomicBoolean criticalFailure = new AtomicBoolean();
        while (currentPath.get() != null && firstCommitParent.get() != null) {
            logHandler.set(GitHistoryUtils.getLogHandler(project, finalRoot, logParser, currentPath.get(), firstCommitParent.get(), parameters));
            final MyTokenAccumulator accumulator = new MyTokenAccumulator(logParser);
            Semaphore semaphore = new Semaphore();
            ((GitLineHandler)logHandler.get()).addLineListener(new GitLineHandlerAdapter((Consumer)resultAdapter, exceptionConsumer, criticalFailure, semaphore){
                final /* synthetic */ Consumer val$resultAdapter;
                final /* synthetic */ Consumer val$exceptionConsumer;
                final /* synthetic */ AtomicBoolean val$criticalFailure;
                final /* synthetic */ Semaphore val$semaphore;
                {
                    this.val$resultAdapter = consumer;
                    this.val$exceptionConsumer = consumer2;
                    this.val$criticalFailure = atomicBoolean;
                    this.val$semaphore = semaphore;
                }

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    GitLogRecord record = accumulator.acceptLine(line);
                    if (record != null) {
                        this.val$resultAdapter.consume((Object)record);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void startFailed(Throwable exception) {
                    try {
                        this.val$exceptionConsumer.consume((Object)new VcsException(exception));
                    }
                    finally {
                        this.val$criticalFailure.set(true);
                        this.val$semaphore.up();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processTerminated(int exitCode) {
                    try {
                        super.processTerminated(exitCode);
                        GitLogRecord record = accumulator.processLast();
                        if (record != null) {
                            this.val$resultAdapter.consume((Object)record);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                        this.val$exceptionConsumer.consume((Object)new VcsException("Internal error " + t.getMessage(), t));
                        this.val$criticalFailure.set(true);
                    }
                    finally {
                        this.val$semaphore.up();
                    }
                }
            });
            semaphore.down();
            ((GitLineHandler)logHandler.get()).start();
            semaphore.waitFor();
            if (criticalFailure.get()) {
                return;
            }
            try {
                FilePath firstCommitRenamePath = GitHistoryUtils.getFirstCommitRenamePath(project, finalRoot, firstCommit.get(), currentPath.get());
                currentPath.set(firstCommitRenamePath);
                skipFurtherOutput.set(false);
            }
            catch (VcsException e) {
                LOG.warn("Tried to get first commit rename path", (Throwable)e);
                exceptionConsumer.consume((Object)e);
                return;
            }
        }
    }

    private static GitLineHandler getLogHandler(Project project, VirtualFile root, GitLogParser parser, FilePath path, String lastCommit, String ... parameters) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (parameters != null && parameters.length > 0) {
            h.addParameters(parameters);
        }
        h.endOptions();
        h.addRelativePaths(path);
        return h;
    }

    @Nullable
    private static FilePath getFirstCommitRenamePath(Project project, VirtualFile root, String commit, FilePath filePath) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit);
        h.endOptions();
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.isEmpty()) {
            return null;
        }
        List<Change> changes = records.get(0).parseChanges(project, root);
        for (Change change : changes) {
            if (!change.isMoved() && !change.isRenamed() || !filePath.equals(change.getAfterRevision().getFile())) continue;
            return change.getBeforeRevision().getFile();
        }
        return null;
    }

    public static List<? extends VcsShortCommitDetails> readMiniDetails(Project project, final VirtualFile root, List<String> hashes) throws VcsException {
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(hashes));
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        return ContainerUtil.map(records, (Function)new Function<GitLogRecord, VcsShortCommitDetails>(){

            public VcsShortCommitDetails fun(GitLogRecord record) {
                SmartList parents = new SmartList();
                for (String parent : record.getParentsHashes()) {
                    parents.add(HashImpl.build((String)parent));
                }
                return factory.createShortDetails(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail());
            }
        });
    }

    @NotNull
    public static List<TimedVcsCommit> readCommits(@NotNull Project project, @NotNull VirtualFile root, final @NotNull Consumer<VcsUser> userRegistry, @NotNull List<String> parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "readCommits"));
            }
            return list;
        }
        int COMMIT_BUFFER = 1000;
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        final GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL);
        h.setStdoutSuppressed(true);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters("--full-history");
        h.addParameters("--date-order");
        h.addParameters(parameters);
        h.endOptions();
        final ArrayList commits = ContainerUtil.newArrayList();
        final StringBuilder record = new StringBuilder();
        final AtomicInteger records = new AtomicInteger();
        final Ref ex = new Ref();
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                try {
                    String afterParseRemainder;
                    int recordEnd = line.indexOf("\u0003");
                    if (recordEnd == line.length() - 1) {
                        record.append(line);
                        afterParseRemainder = "";
                    } else if (recordEnd == -1) {
                        record.append(line);
                        afterParseRemainder = null;
                    } else {
                        record.append(line.substring(0, recordEnd + 1));
                        afterParseRemainder = line.substring(recordEnd + 1);
                    }
                    if (afterParseRemainder != null && records.incrementAndGet() > 1000) {
                        commits.addAll(GitHistoryUtils.parseCommit(parser, record, (Consumer<VcsUser>)userRegistry, factory));
                        record.setLength(0);
                        record.append(afterParseRemainder);
                    }
                }
                catch (Exception e) {
                    ex.set((Object)new VcsException((Throwable)e));
                }
            }

            public void processTerminated(int exitCode) {
                try {
                    commits.addAll(GitHistoryUtils.parseCommit(parser, record, (Consumer<VcsUser>)userRegistry, factory));
                }
                catch (Exception e) {
                    ex.set((Object)new VcsException((Throwable)e));
                }
            }

            public void startFailed(Throwable exception) {
                ex.set((Object)new VcsException(exception));
            }
        });
        h.runInCurrentThread(null);
        if (!ex.isNull()) {
            throw (VcsException)((Object)ex.get());
        }
        ArrayList arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        return arrayList;
    }

    @NotNull
    private static List<TimedVcsCommit> parseCommit(@NotNull GitLogParser parser, @NotNull StringBuilder record, final @NotNull Consumer<VcsUser> userRegistry, final @NotNull VcsLogObjectsFactory factory) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        List<GitLogRecord> rec = parser.parse(record.toString());
        List list = ContainerUtil.mapNotNull(rec, (Function)new Function<GitLogRecord, TimedVcsCommit>(){

            public TimedVcsCommit fun(GitLogRecord record) {
                if (record == null) {
                    return null;
                }
                TimedVcsCommit commit = GitHistoryUtils.convert(record, factory);
                userRegistry.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
                return commit;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        return list;
    }

    @NotNull
    private static TimedVcsCommit convert(@NotNull GitLogRecord rec, @NotNull VcsLogObjectsFactory factory) {
        if (rec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "convert"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "convert"));
        }
        List<Hash> parents = GitHistoryUtils.getParentHashes(factory, rec);
        TimedVcsCommit timedVcsCommit = factory.createTimedCommit(HashImpl.build((String)rec.getHash()), parents, rec.getCommitTime());
        if (timedVcsCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "convert"));
        }
        return timedVcsCommit;
    }

    @Nullable
    private static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "getObjectsFactoryWithDisposeCheck"));
        }
        return (VcsLogObjectsFactory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VcsLogObjectsFactory>(){

            public VcsLogObjectsFactory compute() {
                if (!project.isDisposed()) {
                    return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
                }
                return null;
            }
        });
    }

    public static List<VcsFileRevision> history(Project project, FilePath path) throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(path);
        return GitHistoryUtils.history(project, path, root, new String[0]);
    }

    public static List<VcsFileRevision> history(Project project, FilePath path, VirtualFile root, String ... parameters) throws VcsException {
        final ArrayList<VcsFileRevision> rc = new ArrayList<VcsFileRevision>();
        final ArrayList exceptions = new ArrayList();
        GitHistoryUtils.history(project, path, root, new Consumer<GitFileRevision>(){

            public void consume(GitFileRevision gitFileRevision) {
                rc.add(gitFileRevision);
            }
        }, new Consumer<VcsException>(){

            public void consume(VcsException e) {
                exceptions.add(e);
            }
        }, parameters);
        if (!exceptions.isEmpty()) {
            throw (VcsException)((Object)exceptions.get(0));
        }
        return rc;
    }

    public static List<Pair<SHAHash, Date>> onlyHashesHistory(Project project, FilePath path, String ... parameters) throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(path);
        return GitHistoryUtils.onlyHashesHistory(project, path, root, parameters);
    }

    public static List<Pair<SHAHash, Date>> onlyHashesHistory(Project project, FilePath path, VirtualFile root, String ... parameters) throws VcsException {
        path = GitHistoryUtils.getLastCommitName(project, path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        String output = h.run();
        ArrayList<Pair<SHAHash, Date>> rc = new ArrayList<Pair<SHAHash, Date>>();
        for (GitLogRecord record : parser.parse(output)) {
            record.setUsedHandler(h);
            rc.add((Pair<SHAHash, Date>)new Pair((Object)new SHAHash(record.getHash()), (Object)record.getDate()));
        }
        return rc;
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> loadMetadata(@NotNull Project project, final @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadMetadata"));
            }
            return list;
        }
        List<VcsCommitMetadata> list = GitHistoryUtils.loadDetails(project, root, false, new NullableFunction<GitLogRecord, VcsCommitMetadata>(){

            @Nullable
            public VcsCommitMetadata fun(GitLogRecord record) {
                return factory.createCommitMetadata(factory.createHash(record.getHash()), GitHistoryUtils.getParentHashes(factory, record), record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
            }
        }, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        return list;
    }

    @NotNull
    public static List<GitCommit> history(final @NotNull Project project, final @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "history"));
        }
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<GitCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
            }
            return list;
        }
        List<GitCommit> list = GitHistoryUtils.loadDetails(project, root, true, new NullableFunction<GitLogRecord, GitCommit>(){

            @Nullable
            public GitCommit fun(GitLogRecord record) {
                try {
                    return GitHistoryUtils.createCommit(project, root, record, factory);
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        }, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> loadDetails(@NotNull Project project, @NotNull VirtualFile root, boolean withChanges, @NotNull NullableFunction<GitLogRecord, T> converter, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser.NameStatus status = withChanges ? GitLogParser.NameStatus.STATUS : GitLogParser.NameStatus.NONE;
        GitLogParser parser = new GitLogParser(project, status, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters("--full-history", "--sparse");
        if (withChanges) {
            h.addParameters("-M", "--name-status");
        }
        h.endOptions();
        StopWatch sw = StopWatch.start((String)"loading details");
        String output = h.run();
        sw.report();
        sw = StopWatch.start((String)"parsing");
        List<GitLogRecord> records = parser.parse(output);
        sw.report();
        sw = StopWatch.start((String)"Creating objects");
        List commits = ContainerUtil.mapNotNull(records, converter);
        sw.report();
        List list = commits;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        return list;
    }

    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogRecord record, @NotNull VcsLogObjectsFactory factory) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        List<Hash> parents = GitHistoryUtils.getParentHashes(factory, record);
        return new GitCommit(project, HashImpl.build((String)record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), factory.createUser(record.getAuthorName(), record.getAuthorEmail()), record.getFullMessage(), factory.createUser(record.getCommitterName(), record.getCommitterEmail()), record.getAuthorTimeStamp(), record.getStatusInfos());
    }

    @NotNull
    private static List<Hash> getParentHashes(final @NotNull VcsLogObjectsFactory factory, @NotNull GitLogRecord record) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        List list = ContainerUtil.map((Object[])record.getParentsHashes(), (Function)new Function<String, Hash>(){

            public Hash fun(String hash) {
                return factory.createHash(hash);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        return list;
    }

    public static void historyWithLinks(final Project project, FilePath path, final @Nullable SymbolicRefsI refs, final @NotNull AsynchConsumer<GitHeavyCommit> gitCommitConsumer, final @Nullable Getter<Boolean> isCanceled, @Nullable Collection<VirtualFile> paths, boolean fullHistory, String ... parameters) throws VcsException {
        if (gitCommitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "historyWithLinks"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        final VirtualFile root = GitUtil.getGitRoot(path);
        final GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        final GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.REF_NAMES, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8");
        if (fullHistory) {
            h.addParameters("--full-history");
        }
        if (paths != null && !paths.isEmpty()) {
            h.endOptions();
            h.addRelativeFiles(paths);
        } else {
            if (fullHistory) {
                h.addParameters("--sparse");
            }
            h.endOptions();
            h.addRelativePaths(path);
        }
        final VcsException[] exc = new VcsException[1];
        final Semaphore semaphore = new Semaphore();
        final StringBuilder sb = new StringBuilder();
        final Ref skipFirst = new Ref((Object)true);
        h.addLineListener(new GitLineHandlerAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                try {
                    if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                        if (isCanceled != null && ((Boolean)isCanceled.get()).booleanValue()) {
                            h.cancel();
                            return;
                        }
                        if (!line.startsWith("\u0001") || ((Boolean)skipFirst.get()).booleanValue()) {
                            if (sb.length() > 0) {
                                sb.append("\n");
                            }
                            sb.append(line);
                            skipFirst.set((Object)false);
                            return;
                        }
                        GitHistoryUtils.takeLine(project, line, sb, parser, refs, root, exc, h, (AsynchConsumer<GitHeavyCommit>)gitCommitConsumer);
                    }
                }
                catch (ProcessCanceledException e) {
                    h.cancel();
                    semaphore.up();
                }
            }

            @Override
            public void processTerminated(int exitCode) {
                semaphore.up();
            }

            @Override
            public void startFailed(Throwable exception) {
                semaphore.up();
            }
        });
        semaphore.down();
        h.start();
        semaphore.waitFor();
        GitHistoryUtils.takeLine(project, "", sb, parser, refs, root, exc, h, gitCommitConsumer);
        gitCommitConsumer.finished();
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    private static void takeLine(Project project, String line, StringBuilder sb, GitLogParser parser, SymbolicRefsI refs, VirtualFile root, VcsException[] exc, GitLineHandler h, AsynchConsumer<GitHeavyCommit> gitCommitConsumer) {
        GitHeavyCommit gitCommit;
        String text = sb.toString();
        sb.setLength(0);
        sb.append(line);
        if (text.length() == 0) {
            return;
        }
        GitLogRecord record = parser.parseOneRecord(text);
        try {
            gitCommit = GitHistoryUtils.createCommit(project, refs, root, record);
        }
        catch (VcsException e) {
            exc[0] = e;
            h.cancel();
            return;
        }
        gitCommitConsumer.consume((Object)gitCommit);
    }

    @NotNull
    private static GitHeavyCommit createCommit(@NotNull Project project, @Nullable SymbolicRefsI refs, @NotNull VirtualFile root, @NotNull GitLogRecord record) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        Collection<String> currentRefs = record.getRefs();
        ArrayList<String> locals = new ArrayList<String>();
        ArrayList<String> remotes = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        String s = GitHistoryUtils.parseRefs(refs, currentRefs, locals, remotes, tags);
        GitHeavyCommit gitCommit = new GitHeavyCommit(root, AbstractHash.create(record.getHash()), new SHAHash(record.getHash()), record.getAuthorName(), record.getCommitterName(), record.getDate(), record.getSubject(), record.getFullMessage(), new HashSet<String>(Arrays.asList(record.getParentsHashes())), record.getFilePaths(root), record.getAuthorEmail(), record.getCommitterEmail(), tags, locals, remotes, record.parseChanges(project, root), record.getAuthorTimeStamp());
        gitCommit.setCurrentBranch(s);
        GitHeavyCommit gitHeavyCommit = gitCommit;
        if (gitHeavyCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        return gitHeavyCommit;
    }

    @Nullable
    private static String parseRefs(@Nullable SymbolicRefsI refs, Collection<String> currentRefs, List<String> locals, List<String> remotes, List<String> tags) {
        if (refs == null) {
            return null;
        }
        for (String ref : currentRefs) {
            SymbolicRefs.Kind kind = refs.getKind(ref);
            if (SymbolicRefs.Kind.LOCAL.equals((Object)kind)) {
                locals.add(ref);
                continue;
            }
            if (SymbolicRefs.Kind.REMOTE.equals((Object)kind)) {
                remotes.add(ref);
                continue;
            }
            tags.add(ref);
        }
        if (refs.getCurrent() != null && currentRefs.contains(refs.getCurrent().getName())) {
            return refs.getCurrent().getName();
        }
        return null;
    }

    @Nullable
    public static Pair<AbstractHash, AbstractHash> getStashTop(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "getStashTop"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "getStashTop"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.STASH.readLockingCommand());
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("list");
        h.addParameters("-n1");
        h.addParameters(parser.getPretty());
        h.setCharset(Charset.forName(GitConfigUtil.getLogEncoding(project, root)));
        String out = h.run();
        List<GitLogRecord> gitLogRecords = parser.parse(out);
        Iterator<GitLogRecord> i$ = gitLogRecords.iterator();
        if (i$.hasNext()) {
            GitLogRecord gitLogRecord = i$.next();
            ProgressManager.checkCanceled();
            GitSimpleHandler h1 = new GitSimpleHandler(project, root, GitCommand.LOG);
            GitLogParser parser1 = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT);
            h1.setSilent(true);
            h1.addParameters("-n1");
            h1.addParameters(parser1.getPretty());
            h1.addParameters(gitLogRecord.getHash());
            String out1 = h1.run();
            List<GitLogRecord> gitLogRecords1 = parser1.parse(out1);
            LOG.assertTrue(gitLogRecords1.size() == 1, (Object)String.format("gitLogRecords size is incorrect. size: %s, records: %s, output: %s", gitLogRecords1.size(), gitLogRecords1, out1));
            GitLogRecord logRecord = gitLogRecords1.get(0);
            String[] parentsShortHashes = logRecord.getParentsHashes();
            String indexCommit = null;
            if (parentsShortHashes.length == 2) {
                if (logRecord.getSubject().contains(parentsShortHashes[0])) {
                    indexCommit = parentsShortHashes[1];
                }
                if (logRecord.getSubject().contains(parentsShortHashes[1])) {
                    indexCommit = parentsShortHashes[0];
                }
            }
            return new Pair((Object)AbstractHash.create(gitLogRecord.getHash()), (Object)(indexCommit == null ? null : AbstractHash.create(indexCommit)));
        }
        return null;
    }

    @Nullable
    public static List<Pair<String, GitHeavyCommit>> loadStashStackAsCommits(@NotNull Project project, @NotNull VirtualFile root, SymbolicRefsI refs, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "loadStashStackAsCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "loadStashStackAsCommits"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.STASH.readLockingCommand());
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.REF_NAMES, GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("list");
        h.addParameters(parameters);
        h.addParameters(parser.getPretty());
        h.setCharset(Charset.forName(GitConfigUtil.getLogEncoding(project, root)));
        String out = h.run();
        List<GitLogRecord> gitLogRecords = parser.parse(out);
        ArrayList<Pair<String, GitHeavyCommit>> result = new ArrayList<Pair<String, GitHeavyCommit>>();
        for (GitLogRecord gitLogRecord : gitLogRecords) {
            ProgressManager.checkCanceled();
            GitHeavyCommit gitCommit = GitHistoryUtils.createCommit(project, refs, root, gitLogRecord);
            result.add((Pair<String, GitHeavyCommit>)new Pair((Object)gitLogRecord.getShortenedRefLog(), (Object)gitCommit));
        }
        return result;
    }

    @Deprecated
    @NotNull
    public static List<GitHeavyCommit> commitsDetails(@NotNull Project project, @NotNull FilePath path, @Nullable SymbolicRefsI refs, @NotNull Collection<String> commitsIds) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (commitsIds == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.REF_NAMES, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("--name-status", "-M", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(commitsIds));
        String output = h.run();
        ArrayList<GitHeavyCommit> rc = new ArrayList<GitHeavyCommit>();
        for (GitLogRecord record : parser.parse(output)) {
            GitHeavyCommit gitCommit = GitHistoryUtils.createCommit(project, refs, root, record);
            rc.add(gitCommit);
        }
        ArrayList<GitHeavyCommit> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GitCommit> commitsDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> hashes) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        ArrayList<String> params = new ArrayList<String>(hashes);
        GitVcs vcs = GitVcs.getInstance(project);
        String noWalk = vcs != null && GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(vcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
        params.add(0, noWalk);
        List<GitCommit> list = GitHistoryUtils.getAllDetails(project, root, params);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        return list;
    }

    @NotNull
    public static List<GitCommit> getAllDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "getAllDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitHistoryUtils", "getAllDetails"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "getAllDetails"));
        }
        VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<GitCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "getAllDetails"));
            }
            return list;
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.REF_NAMES, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("--name-status", "-M", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(parameters);
        String output = h.run();
        ArrayList<GitCommit> rc = new ArrayList<GitCommit>();
        for (GitLogRecord record : parser.parse(output)) {
            rc.add(GitHistoryUtils.createCommit(project, root, record, factory));
        }
        ArrayList<GitCommit> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "getAllDetails"));
        }
        return arrayList;
    }

    public static long getAuthorTime(Project project, FilePath path, String commitsId) throws VcsException {
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(commitsId);
        String output = h.run();
        GitLogRecord logRecord = parser.parseOneRecord(output);
        return logRecord.getAuthorTimeStamp();
    }

    public static void hashesWithParents(Project project, FilePath path, final AsynchConsumer<CommitHashPlusParents> consumer, final Getter<Boolean> isCanceled, Collection<VirtualFile> paths, String ... parameters) throws VcsException {
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        final GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        final GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NAME, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8", "--full-history");
        if (paths != null && !paths.isEmpty()) {
            h.endOptions();
            h.addRelativeFiles(paths);
        } else {
            h.addParameters("--sparse");
            h.endOptions();
            h.addRelativePaths(path);
        }
        final Semaphore semaphore = new Semaphore();
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                try {
                    if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                        if (isCanceled != null && ((Boolean)isCanceled.get()).booleanValue()) {
                            h.cancel();
                            return;
                        }
                        GitLogRecord record = parser.parseOneRecord(line);
                        consumer.consume((Object)new CommitHashPlusParents(record.getHash(), record.getParentsHashes(), record.getCommitTime(), record.getAuthorName()));
                    }
                }
                catch (ProcessCanceledException e) {
                    h.cancel();
                    semaphore.up();
                }
            }

            public void processTerminated(int exitCode) {
                semaphore.up();
            }

            public void startFailed(Throwable exception) {
                semaphore.up();
            }
        });
        semaphore.down();
        h.start();
        semaphore.waitFor();
        consumer.finished();
    }

    public static FilePath getLastCommitName(@NotNull Project project, FilePath path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitHistoryUtils", "getLastCommitName"));
        }
        if (project.isDefault()) {
            return path;
        }
        ChangeListManager changeManager = ChangeListManager.getInstance((Project)project);
        Change change = changeManager.getChange(path);
        if (change != null && change.getType() == Change.Type.MOVED) {
            assert (change.getBeforeRevision() != null) : "Move change always have beforeRevision";
            path = change.getBeforeRevision().getFile();
        }
        return path;
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(Project project, VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.MERGE_BASE);
        h.setSilent(true);
        h.addParameters(first, second);
        String output = h.run().trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    private static class MyTokenAccumulator {
        private final StringBuilder myBuffer = new StringBuilder();
        private boolean myNotStarted = true;
        private GitLogParser myParser;

        public MyTokenAccumulator(GitLogParser parser) {
            this.myParser = parser;
        }

        @Nullable
        public GitLogRecord acceptLine(String s) {
            boolean lineEnd = s.startsWith("\u0001");
            if (lineEnd && !this.myNotStarted) {
                String line = this.myBuffer.toString();
                this.myBuffer.setLength(0);
                this.myBuffer.append(s.substring("\u0001".length()));
                return this.processResult(line);
            }
            this.myBuffer.append(lineEnd ? s.substring("\u0001".length()) : s);
            this.myBuffer.append("\n");
            this.myNotStarted = false;
            return null;
        }

        public GitLogRecord processLast() {
            return this.processResult(this.myBuffer.toString());
        }

        private GitLogRecord processResult(String line) {
            return this.myParser.parseOneRecord(line);
        }
    }
}

