/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.history.GitLogStatusInfo;
import git4idea.history.wholeTree.AbstractHash;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitChangesParser {
    @NotNull
    public static List<Change> parse(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogStatusInfo> statusInfos, @NotNull String hash, @NotNull Date date, @NotNull List<String> parentsHashes) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/history/GitChangesParser", "parse"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/history/GitChangesParser", "parse"));
        }
        if (statusInfos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/history/GitChangesParser", "parse"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/history/GitChangesParser", "parse"));
        }
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/history/GitChangesParser", "parse"));
        }
        if (parentsHashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/history/GitChangesParser", "parse"));
        }
        GitRevisionNumber thisRevision = new GitRevisionNumber(hash, date);
        List<GitRevisionNumber> parentRevisions = GitChangesParser.prepareParentRevisions(parentsHashes);
        ArrayList<Change> result = new ArrayList<Change>();
        for (GitLogStatusInfo statusInfo : statusInfos) {
            result.add(GitChangesParser.parseChange(project, root, parentRevisions, statusInfo, (VcsRevisionNumber)thisRevision));
        }
        ArrayList<Change> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitChangesParser", "parse"));
        }
        return arrayList;
    }

    private static List<GitRevisionNumber> prepareParentRevisions(List<String> parentsHashes) {
        ArrayList<AbstractHash> parents = new ArrayList<AbstractHash>(parentsHashes.size());
        for (String parentsShortHash : parentsHashes) {
            parents.add(AbstractHash.create(parentsShortHash));
        }
        ArrayList<GitRevisionNumber> parentRevisions = new ArrayList<GitRevisionNumber>(parents.size());
        for (AbstractHash parent : parents) {
            parentRevisions.add(new GitRevisionNumber(parent.getString()));
        }
        return parentRevisions;
    }

    private static Change parseChange(Project project, VirtualFile vcsRoot, List<GitRevisionNumber> parentRevisions, GitLogStatusInfo statusInfo, VcsRevisionNumber thisRevision) throws VcsException {
        ContentRevision after;
        ContentRevision before;
        FileStatus status = null;
        String path = statusInfo.getFirstPath();
        GitRevisionNumber firstParent = parentRevisions.isEmpty() ? null : parentRevisions.get(0);
        switch (statusInfo.getType()) {
            case ADDED: {
                before = null;
                status = FileStatus.ADDED;
                after = GitContentRevision.createRevision(vcsRoot, path, thisRevision, project, false, false, true);
                break;
            }
            case UNRESOLVED: {
                status = FileStatus.MERGED_WITH_CONFLICTS;
            }
            case MODIFIED: {
                if (status == null) {
                    status = FileStatus.MODIFIED;
                }
                FilePath filePath = GitContentRevision.createPath(vcsRoot, path, false, true, true);
                before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)firstParent, project, false, false, true);
                after = GitContentRevision.createRevision(filePath, thisRevision, project, null);
                break;
            }
            case DELETED: {
                status = FileStatus.DELETED;
                FilePath filePathDeleted = GitContentRevision.createPath(vcsRoot, path, true, true, true);
                before = GitContentRevision.createRevision(filePathDeleted, (VcsRevisionNumber)firstParent, project, null);
                after = null;
                break;
            }
            case COPIED: 
            case RENAMED: {
                status = FileStatus.MODIFIED;
                String secondPath = statusInfo.getSecondPath();
                FilePath filePathAfterRename = GitContentRevision.createPath(vcsRoot, secondPath == null ? path : secondPath, false, false, true);
                before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)firstParent, project, true, true, true);
                after = GitContentRevision.createRevision(filePathAfterRename, thisRevision, project, null);
                break;
            }
            case TYPE_CHANGED: {
                status = FileStatus.MODIFIED;
                FilePath filePath2 = GitContentRevision.createPath(vcsRoot, path, false, true, true);
                before = GitContentRevision.createRevision(vcsRoot, path, (VcsRevisionNumber)firstParent, project, false, false, true);
                after = GitContentRevision.createRevision(filePath2, thisRevision, project, null);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown file status: " + statusInfo));
            }
        }
        return new Change(before, after, status);
    }
}

