/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitVcs;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchSyncSetting;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitVcsPanel {
    private static final String IDEA_SSH = GitBundle.getString("git.vcs.config.ssh.mode.idea");
    private static final String NATIVE_SSH = GitBundle.getString("git.vcs.config.ssh.mode.native");
    private final GitVcsApplicationSettings myAppSettings;
    private final GitVcs myVcs;
    private JButton myTestButton;
    private JComponent myRootPanel;
    private TextFieldWithBrowseButton myGitField;
    private JComboBox mySSHExecutableComboBox;
    private JCheckBox myAutoUpdateIfPushRejected;
    private JBCheckBox mySyncBranchControl;
    private JCheckBox myAutoCommitOnCherryPick;
    private JBCheckBox myWarnAboutCrlf;

    public GitVcsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/config/GitVcsPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myVcs = GitVcs.getInstance(project);
        this.myAppSettings = GitVcsApplicationSettings.getInstance();
        this.mySSHExecutableComboBox.addItem(IDEA_SSH);
        this.mySSHExecutableComboBox.addItem(NATIVE_SSH);
        this.mySSHExecutableComboBox.setSelectedItem(IDEA_SSH);
        this.mySSHExecutableComboBox.setToolTipText(GitBundle.message("git.vcs.config.ssh.mode.tooltip", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitVcsPanel.this.testConnection();
            }
        });
        this.myGitField.addBrowseFolderListener(GitBundle.getString("find.git.title"), GitBundle.getString("find.git.description"), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        GitRepositoryManager repositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        this.mySyncBranchControl.setVisible(repositoryManager != null && repositoryManager.moreThanOneRoot());
    }

    private void testConnection() {
        GitVersion version;
        String executable = this.getCurrentExecutablePath();
        if (this.myAppSettings != null) {
            this.myAppSettings.setPathToGit(executable);
        }
        try {
            version = GitVersion.identifyVersion(executable);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.myRootPanel, (String)e.getMessage(), (String)GitBundle.getString("find.git.error.title"));
            return;
        }
        if (version.isSupported()) {
            Messages.showInfoMessage((Component)this.myRootPanel, (String)String.format("<html>%s<br>Git version is %s</html>", GitBundle.getString("find.git.success.title"), version.toString()), (String)GitBundle.getString("find.git.success.title"));
        } else {
            Messages.showWarningDialog((Component)this.myRootPanel, (String)GitBundle.message("find.git.unsupported.message", version.toString(), GitVersion.MIN), (String)GitBundle.getString("find.git.success.title"));
        }
    }

    private String getCurrentExecutablePath() {
        return this.myGitField.getText().trim();
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    public void load(@NotNull GitVcsSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/config/GitVcsPanel", "load"));
        }
        this.myGitField.setText(settings.getAppSettings().getPathToGit());
        this.mySSHExecutableComboBox.setSelectedItem(settings.isIdeaSsh() ? IDEA_SSH : NATIVE_SSH);
        this.myAutoUpdateIfPushRejected.setSelected(settings.autoUpdateIfPushRejected());
        this.mySyncBranchControl.setSelected(settings.getSyncSetting() == GitBranchSyncSetting.SYNC);
        this.myAutoCommitOnCherryPick.setSelected(settings.isAutoCommitOnCherryPick());
        this.myWarnAboutCrlf.setSelected(settings.warnAboutCrlf());
    }

    public boolean isModified(@NotNull GitVcsSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/config/GitVcsPanel", "isModified"));
        }
        return !settings.getAppSettings().getPathToGit().equals(this.getCurrentExecutablePath()) || settings.isIdeaSsh() != IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) || !settings.autoUpdateIfPushRejected() == this.myAutoUpdateIfPushRejected.isSelected() || settings.getSyncSetting() == GitBranchSyncSetting.SYNC != this.mySyncBranchControl.isSelected() || settings.isAutoCommitOnCherryPick() != this.myAutoCommitOnCherryPick.isSelected() || settings.warnAboutCrlf() != this.myWarnAboutCrlf.isSelected();
    }

    public void save(@NotNull GitVcsSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/config/GitVcsPanel", "save"));
        }
        settings.getAppSettings().setPathToGit(this.getCurrentExecutablePath());
        this.myVcs.checkVersion();
        settings.getAppSettings().setIdeaSsh(IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) ? GitVcsApplicationSettings.SshExecutable.IDEA_SSH : GitVcsApplicationSettings.SshExecutable.NATIVE_SSH);
        settings.setAutoUpdateIfPushRejected(this.myAutoUpdateIfPushRejected.isSelected());
        settings.setSyncSetting(this.mySyncBranchControl.isSelected() ? GitBranchSyncSetting.SYNC : GitBranchSyncSetting.DONT);
        settings.setAutoCommitOnCherryPick(this.myAutoCommitOnCherryPick.isSelected());
        settings.setWarnAboutCrlf(this.myWarnAboutCrlf.isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox2;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JComboBox jComboBox;
        JPanel jPanel = new JPanel();
        this.myRootPanel = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 7, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.path.label"));
        jLabel.setVerifyInputWhenFocusTarget(false);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.ssh.mode"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySSHExecutableComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGitField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setLabel(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test.label"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test"));
        jButton.setHorizontalAlignment(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 2, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAutoUpdateIfPushRejected = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Auto-update if push of the current branch was rejected");
        jCheckBox2.setMnemonic('P');
        jCheckBox2.setDisplayedMnemonicIndex(15);
        jCheckBox2.setIconTextGap(4);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySyncBranchControl = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setToolTipText("If selected, you would be able to checkout, compare, delete and create new branches in all Git roots with a single action");
        jBCheckBox2.setText("Control branches from different roots synchronously");
        jBCheckBox2.setMnemonic('B');
        jBCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoCommitOnCherryPick = jCheckBox = new JCheckBox();
        jCheckBox.setText("Commit automatically on cherry-pick");
        jCheckBox.setIconTextGap(4);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWarnAboutCrlf = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Warn if CRLF line separators are about to be committed");
        jBCheckBox.setMnemonic('C');
        jBCheckBox.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

