/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitMessageWithFilesDetector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GitLocalChangesWouldBeOverwrittenDetector
extends GitMessageWithFilesDetector {
    private static final Pattern OLD_CHECKOUT_PATTERN = Pattern.compile(".*You have local changes to '(.*)'; cannot switch branches.*");
    private static final Pattern OLD_MERGE_PATTERN = Pattern.compile(".*Your local changes to '(.*)' would be overwritten by merge.*");
    public static final GitMessageWithFilesDetector.Event NEW_PATTERN = new GitMessageWithFilesDetector.Event("Your local changes to the following files would be overwritten by", "commit your changes or stash them before");
    @NotNull
    private final Operation myOperation;

    public GitLocalChangesWouldBeOverwrittenDetector(@NotNull VirtualFile root, @NotNull Operation operation) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector", "<init>"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector", "<init>"));
        }
        super(NEW_PATTERN, root);
        this.myOperation = operation;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector", "onLineAvailable"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector", "onLineAvailable"));
        }
        super.onLineAvailable(line, outputType);
        Matcher m = this.myOperation.getPattern().matcher(line);
        if (m.matches()) {
            this.myMessageDetected = true;
            this.myAffectedFiles.add(m.group(1));
        }
    }

    static /* synthetic */ Pattern access$000() {
        return OLD_CHECKOUT_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return OLD_MERGE_PATTERN;
    }

    public static enum Operation {
        CHECKOUT(GitLocalChangesWouldBeOverwrittenDetector.access$000()),
        MERGE(GitLocalChangesWouldBeOverwrittenDetector.access$100());

        @NotNull
        private final Pattern myPattern;

        private Operation(Pattern pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector$Operation", "<init>"));
            }
            this.myPattern = pattern;
        }

        @NotNull
        public Pattern getPattern() {
            Pattern pattern = this.myPattern;
            if (pattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector$Operation", "getPattern"));
            }
            return pattern;
        }
    }
}

