/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.LineHandlerHelper;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitTextHandler;
import java.io.File;
import java.util.EventListener;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class GitLineHandler
extends GitTextHandler {
    private final StringBuilder myStdoutLine;
    private final StringBuilder myStderrLine;
    private final EventDispatcher<GitLineHandlerListener> myLineListeners;

    public GitLineHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitLineHandler", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitLineHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/commands/GitLineHandler", "<init>"));
        }
        super(project, directory, command);
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/commands/GitLineHandler", "<init>"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/commands/GitLineHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/commands/GitLineHandler", "<init>"));
        }
        super(project, vcsRoot, command);
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    }

    @Override
    protected void processTerminated(int exitCode) {
        if (this.myStdoutLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDOUT);
        } else if (!this.isStderrSuppressed() && this.myStderrLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDERR);
        }
    }

    public void addLineListener(GitLineHandlerListener listener) {
        super.addListener((ProcessEventListener)listener);
        this.myLineListeners.addListener((EventListener)((Object)listener));
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        Iterator<String> lines = LineHandlerHelper.splitText((String)text).iterator();
        if (ProcessOutputTypes.STDOUT == outputType) {
            this.notifyLines(outputType, lines, this.myStdoutLine);
        } else if (ProcessOutputTypes.STDERR == outputType) {
            this.notifyLines(outputType, lines, this.myStderrLine);
        }
    }

    private void notifyLines(Key outputType, Iterator<String> lines, StringBuilder lineBuilder) {
        block5: {
            String line;
            if (!lines.hasNext()) {
                return;
            }
            if (lineBuilder.length() > 0) {
                lineBuilder.append(lines.next());
                if (lines.hasNext()) {
                    line = lineBuilder.toString();
                    this.notifyLine(line, outputType);
                    lineBuilder.setLength(0);
                }
            }
            while (true) {
                line = null;
                if (lines.hasNext()) {
                    line = lines.next();
                }
                if (!lines.hasNext()) break;
                this.notifyLine(line, outputType);
            }
            if (line == null || line.length() <= 0) break block5;
            lineBuilder.append(line);
        }
    }

    private void notifyLine(String line, Key outputType) {
        String trimmed = LineHandlerHelper.trimLineSeparator((String)line);
        if (this.myVcs != null && !"\r".equals(line.substring(trimmed.length()))) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                if (!(this.isStdoutSuppressed() || this.mySilent || StringUtil.isEmptyOrSpaces((String)line))) {
                    this.myVcs.showMessages(trimmed);
                    LOG.info(line.trim());
                } else {
                    OUTPUT_LOG.debug(line.trim());
                }
            } else if (!(outputType != ProcessOutputTypes.STDERR || this.isStderrSuppressed() || this.mySilent || StringUtil.isEmptyOrSpaces((String)line))) {
                this.myVcs.showErrorMessages(trimmed);
                LOG.info(line.trim());
            } else {
                LOG.debug(line.trim());
            }
        }
        ((GitLineHandlerListener)((Object)this.myLineListeners.getMulticaster())).onLineAvailable(trimmed, outputType);
    }
}

