/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitHandlerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class GitBinaryHandler
extends GitHandler {
    private static final int BUFFER_SIZE = 8192;
    @NotNull
    private final ByteArrayOutputStream myStdout = new ByteArrayOutputStream();
    @NotNull
    private final ByteArrayOutputStream myStderr = new ByteArrayOutputStream();
    @NotNull
    private final Semaphore mySteamSemaphore = new Semaphore(0);
    @NotNull
    private final AtomicReference<VcsException> myException = new AtomicReference();

    public GitBinaryHandler(Project project, VirtualFile vcsRoot, GitCommand command) {
        super(project, vcsRoot, command);
    }

    @Override
    protected Process startProcess() throws ExecutionException {
        return this.myCommandLine.createProcess();
    }

    @Override
    protected void startHandlingStreams() {
        this.handleStream(this.myProcess.getErrorStream(), this.myStderr);
        this.handleStream(this.myProcess.getInputStream(), this.myStdout);
    }

    private void handleStream(final InputStream in, final ByteArrayOutputStream out) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int rc;
                    byte[] buffer = new byte[8192];
                    while ((rc = in.read(buffer)) != -1) {
                        out.write(buffer, 0, rc);
                    }
                }
                catch (IOException e) {
                    if (!GitBinaryHandler.this.myException.compareAndSet(null, new VcsException("Stream IO problem", (Throwable)e))) {
                        GitHandler.LOG.error("Problem reading stream", (Throwable)e);
                    }
                }
                finally {
                    GitBinaryHandler.this.mySteamSemaphore.release(1);
                }
            }
        }, "Stream copy thread");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void destroyProcess() {
        this.myProcess.destroy();
    }

    @Override
    protected void waitForProcess() {
        try {
            this.mySteamSemaphore.acquire(2);
            this.myProcess.waitFor();
            int exitCode = this.myProcess.exitValue();
            this.setExitCode(exitCode);
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring process exception: ", (Throwable)e);
            }
            this.setExitCode(255);
        }
        this.listeners().processTerminated(this.getExitCode());
    }

    public byte[] run() throws VcsException {
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                if (exitCode != 0 && !GitBinaryHandler.this.isIgnoredErrorCode(exitCode)) {
                    VcsException e;
                    Charset cs = GitBinaryHandler.this.getCharset();
                    cs = cs == null ? GitUtil.UTF8_CHARSET : cs;
                    String message = new String(GitBinaryHandler.this.myStderr.toByteArray(), cs);
                    if (message.length() == 0) {
                        message = GitBinaryHandler.this.myException.get() != null ? IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode}) : null;
                    } else if (!GitBinaryHandler.this.isStderrSuppressed()) {
                        GitVcs.getInstance(GitBinaryHandler.this.myProject).showErrorMessages(message);
                    }
                    if (message != null && (e = GitBinaryHandler.this.myException.getAndSet(new VcsException(message))) != null) {
                        GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                    }
                }
            }

            public void startFailed(Throwable exception) {
                VcsException e = GitBinaryHandler.this.myException.getAndSet(new VcsException("Start failed: " + exception.getMessage(), exception));
                if (e != null) {
                    GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                }
            }
        });
        GitHandlerUtil.runInCurrentThread(this, null);
        if (this.myException.get() != null) {
            throw this.myException.get();
        }
        return this.myStdout.toByteArray();
    }
}

