/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.jgit.GitHttpAdapter;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckoutProvider
implements CheckoutProvider {
    private final Git myGit;

    public GitCheckoutProvider(@NotNull Git git) {
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/checkout/GitCheckoutProvider", "<init>"));
        }
        this.myGit = git;
    }

    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/checkout/GitCheckoutProvider", "doCheckout"));
        }
        BasicAction.saveAll();
        GitCloneDialog dialog = new GitCloneDialog(project);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        GitCheckoutProvider.clone(project, this.myGit, listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final Project project, final @NotNull Git git, final CheckoutProvider.Listener listener, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/checkout/GitCheckoutProvider", "clone"));
        }
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/checkout/GitCheckoutProvider$1", "run"));
                }
                cloneResult.set(GitCheckoutProvider.doClone(project, indicator, git, directoryName, parentDirectory, sourceRepositoryURL));
            }

            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                destinationParent.refresh(true, true, new Runnable(){

                    @Override
                    public void run() {
                        if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                            VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                            mgr.fileDirty(destinationParent);
                        }
                    }
                });
                listener.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                listener.checkoutCompleted();
            }
        }.queue();
    }

    public static boolean doClone(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryURL) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (parentDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (sourceRepositoryURL == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (GitHttpAdapter.shouldUseJGit(sourceRepositoryURL)) {
            GitFetchResult result = GitHttpAdapter.cloneRepository(project, new File(parentDirectory, directoryName), sourceRepositoryURL);
            GitFetcher.displayFetchResult(project, result, "Clone failed", result.getErrors());
            return result.isSuccess();
        }
        return GitCheckoutProvider.cloneNatively(project, indicator, git, new File(parentDirectory), sourceRepositoryURL, directoryName);
    }

    private static boolean cloneNatively(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Git git, @NotNull File directory, @NotNull String url, @NotNull String cloneDirectoryName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/checkout/GitCheckoutProvider", "cloneNatively"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/checkout/GitCheckoutProvider", "cloneNatively"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/checkout/GitCheckoutProvider", "cloneNatively"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/checkout/GitCheckoutProvider", "cloneNatively"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/checkout/GitCheckoutProvider", "cloneNatively"));
        }
        if (cloneDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/checkout/GitCheckoutProvider", "cloneNatively"));
        }
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result = git.clone(project, directory, url, cloneDirectoryName, progressListener);
        if (result.success()) {
            return true;
        }
        VcsNotifier.getInstance((Project)project).notifyError("Clone failed", result.getErrorOutputAsHtmlString());
        return false;
    }
}

