/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import git4idea.GitBranch;
import git4idea.GitBranchesSearcher;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.GitHistoryUtils;
import git4idea.history.browser.SHAHash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitOutgoingChangesProvider
implements VcsOutgoingChangesProvider<CommittedChangeList> {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.changes.GitOutgoingChangesProvider");
    private final Project myProject;

    public GitOutgoingChangesProvider(Project project) {
        this.myProject = project;
    }

    public Pair<VcsRevisionNumber, List<CommittedChangeList>> getOutgoingChanges(VirtualFile vcsRoot, boolean findRemote) throws VcsException {
        LOG.debug("getOutgoingChanges root: " + vcsRoot.getPath());
        GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, vcsRoot, findRemote);
        if (searcher.getLocal() == null || searcher.getRemote() == null) {
            return new Pair(null, Collections.emptyList());
        }
        final GitRevisionNumber base = GitOutgoingChangesProvider.getMergeBase(this.myProject, vcsRoot, searcher.getLocal(), searcher.getRemote());
        if (base == null) {
            return new Pair(null, Collections.emptyList());
        }
        List<GitCommittedChangeList> lists = GitUtil.getLocalCommittedChanges(this.myProject, vcsRoot, new Consumer<GitSimpleHandler>(){

            public void consume(GitSimpleHandler handler) {
                handler.addParameters(base.asString() + "..HEAD");
            }
        });
        return new Pair((Object)base, (Object)ObjectsConvertor.convert(lists, (Convertor)new Convertor<GitCommittedChangeList, CommittedChangeList>(){

            public CommittedChangeList convert(GitCommittedChangeList o) {
                return o;
            }
        }));
    }

    @Nullable
    public VcsRevisionNumber getMergeBaseNumber(VirtualFile anyFileUnderRoot) throws VcsException {
        LOG.debug("getMergeBaseNumber parameter: " + anyFileUnderRoot.getPath());
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VirtualFile root = vcsManager.getVcsRootFor(anyFileUnderRoot);
        if (root == null) {
            LOG.info("VCS root not found");
            return null;
        }
        GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, root, true);
        if (searcher.getLocal() == null || searcher.getRemote() == null) {
            LOG.info("local or remote not found");
            return null;
        }
        GitRevisionNumber base = GitOutgoingChangesProvider.getMergeBase(this.myProject, root, searcher.getLocal(), searcher.getRemote());
        LOG.debug("found base: " + (base == null ? null : base.asString()));
        return base;
    }

    public Collection<Change> filterLocalChangesBasedOnLocalCommits(Collection<Change> localChanges, VirtualFile vcsRoot) throws VcsException {
        GitRevisionNumber base;
        GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, vcsRoot, true);
        if (searcher.getLocal() == null || searcher.getRemote() == null) {
            return new ArrayList<Change>(localChanges);
        }
        try {
            base = GitOutgoingChangesProvider.getMergeBase(this.myProject, vcsRoot, searcher.getLocal(), searcher.getRemote());
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return new ArrayList<Change>(localChanges);
        }
        if (base == null) {
            return new ArrayList<Change>(localChanges);
        }
        List<Pair<SHAHash, Date>> hashes = GitHistoryUtils.onlyHashesHistory(this.myProject, (FilePath)new FilePathImpl(vcsRoot), vcsRoot, base.asString() + "..HEAD");
        if (hashes.isEmpty()) {
            return Collections.emptyList();
        }
        String first = ((SHAHash)hashes.get(0).getFirst()).getValue();
        HashSet<String> localHashes = new HashSet<String>();
        for (Pair<SHAHash, Date> hash : hashes) {
            localHashes.add(((SHAHash)hash.getFirst()).getValue());
        }
        ArrayList<Change> result = new ArrayList<Change>();
        for (Change change : localChanges) {
            String changeBeforeRevision;
            if (change.getBeforeRevision() == null || !first.equals(changeBeforeRevision = change.getBeforeRevision().getRevisionNumber().asString().trim()) && !localHashes.contains(changeBeforeRevision)) continue;
            result.add(change);
        }
        return result;
    }

    @Nullable
    public Date getRevisionDate(VcsRevisionNumber revision, FilePath file) {
        if (VcsRevisionNumber.NULL.equals(revision)) {
            return null;
        }
        try {
            return new Date(GitHistoryUtils.getAuthorTime(this.myProject, file, revision.asString()));
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    private static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitBranch currentBranch, @NotNull GitBranch branch) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/changes/GitOutgoingChangesProvider", "getMergeBase"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/changes/GitOutgoingChangesProvider", "getMergeBase"));
        }
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/changes/GitOutgoingChangesProvider", "getMergeBase"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/changes/GitOutgoingChangesProvider", "getMergeBase"));
        }
        return GitHistoryUtils.getMergeBase(project, root, currentBranch.getFullName(), branch.getFullName());
    }
}

