/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import git4idea.GitPlatformFacade;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GitSmartOperationDialog
extends DialogWrapper {
    public static final int SMART_EXIT_CODE = 0;
    public static final int FORCE_EXIT_CODE = 2;
    private final Project myProject;
    private final List<Change> myChanges;
    @NotNull
    private final String myOperationTitle;
    private final boolean myForceButton;

    static int showAndGetAnswer(final @NotNull Project project, final @NotNull List<Change> changes, final @NotNull String operationTitle, final boolean forceButton) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitSmartOperationDialog", "showAndGetAnswer"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitSmartOperationDialog", "showAndGetAnswer"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitSmartOperationDialog", "showAndGetAnswer"));
        }
        final AtomicInteger exitCode = new AtomicInteger();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitSmartOperationDialog dialog = new GitSmartOperationDialog(project, changes, operationTitle, forceButton);
                ((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)).showDialog(dialog);
                exitCode.set(dialog.getExitCode());
            }
        });
        return exitCode.get();
    }

    private GitSmartOperationDialog(@NotNull Project project, @NotNull List<Change> changes, @NotNull String operationTitle, boolean forceButton) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitSmartOperationDialog", "<init>"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/branch/GitSmartOperationDialog", "<init>"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/branch/GitSmartOperationDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myChanges = changes;
        this.myOperationTitle = operationTitle;
        this.myForceButton = forceButton;
        this.setOKButtonText("Smart " + StringUtil.capitalize((String)this.myOperationTitle));
        this.setCancelButtonText("Don't " + StringUtil.capitalize((String)this.myOperationTitle));
        this.getCancelAction().putValue("FocusedAction", Boolean.TRUE);
        this.init();
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        if (this.myForceButton) {
            Action[] actionArray = new Action[]{new ForceCheckoutAction(this.myOperationTitle)};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitSmartOperationDialog", "createLeftSideActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitSmartOperationDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    protected JComponent createNorthPanel() {
        JBLabel description = new JBLabel("<html>Your local changes to the following files would be overwritten by " + this.myOperationTitle + ".<br/>" + ApplicationNamesInfo.getInstance().getFullProductName() + " can stash the changes, " + this.myOperationTitle + " and unstash them after that.</html>");
        description.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)10, (int)0));
        return description;
    }

    protected JComponent createCenterPanel() {
        ChangesBrowser changesBrowser = new ChangesBrowser(this.myProject, null, this.myChanges, null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        changesBrowser.setChangesToDisplay(this.myChanges);
        return changesBrowser;
    }

    protected String getDimensionServiceKey() {
        return GitSmartOperationDialog.class.getName();
    }

    private class ForceCheckoutAction
    extends AbstractAction {
        ForceCheckoutAction(String operationTitle) {
            if (operationTitle == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/branch/GitSmartOperationDialog$ForceCheckoutAction", "<init>"));
            }
            super("&Force " + StringUtil.capitalize((String)operationTitle));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitSmartOperationDialog.this.close(2);
        }
    }
}

