/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitRepositoryAction
extends DumbAwareAction {
    final List<TransactionRunnable> myDelayedTasks = new ArrayList<TransactionRunnable>();

    public void actionPerformed(AnActionEvent e) {
        this.myDelayedTasks.clear();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        List<VirtualFile> roots = GitRepositoryAction.getGitRoots(project, vcs);
        if (roots == null) {
            return;
        }
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        VirtualFile defaultRootVar = null;
        if (vFiles != null) {
            for (VirtualFile file : vFiles) {
                VirtualFile root = GitUtil.gitRootOrNull(file);
                if (root == null) continue;
                defaultRootVar = root;
                break;
            }
        }
        if (defaultRootVar == null) {
            defaultRootVar = roots.get(0);
        }
        VirtualFile defaultRoot = defaultRootVar;
        HashSet<VirtualFile> affectedRoots = new HashSet<VirtualFile>();
        String actionName = this.getActionName();
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            this.perform(project, roots, defaultRoot, affectedRoots, exceptions);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
        }
        if (this.executeFinalTasksSynchronously()) {
            this.runFinalTasks(project, vcs, affectedRoots, actionName, exceptions);
        }
    }

    protected final void runFinalTasks(Project project, GitVcs vcs, Set<VirtualFile> affectedRoots, String actionName, List<VcsException> exceptions) {
        VcsFileUtil.refreshFiles((Project)project, affectedRoots);
        for (TransactionRunnable task : this.myDelayedTasks) {
            task.run(exceptions);
        }
        this.myDelayedTasks.clear();
        vcs.showErrors(exceptions, actionName);
    }

    protected boolean executeFinalTasksSynchronously() {
        return true;
    }

    protected static boolean isRebasing(AnActionEvent e) {
        VirtualFile[] files;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && (files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            for (VirtualFile file : files) {
                GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
                if (manager == null) {
                    return false;
                }
                GitRepository repositoryForFile = (GitRepository)manager.getRepositoryForFile(file);
                if (repositoryForFile == null || repositoryForFile.getState() != Repository.State.REBASING) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) {
        List<VirtualFile> roots;
        try {
            roots = GitUtil.getGitRoots(project, vcs);
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)GitBundle.getString("repository.action.missing.roots.title"));
            return null;
        }
        return roots;
    }

    public final void delayTask(@NotNull TransactionRunnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitRepositoryAction", "delayTask"));
        }
        this.myDelayedTasks.add(task);
    }

    @NotNull
    protected abstract String getActionName();

    protected abstract void perform(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3, Set<VirtualFile> var4, List<VcsException> var5) throws VcsException;

    public void update(AnActionEvent e) {
        super.update(e);
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
    }

    protected boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        return roots != null && roots.length != 0;
    }
}

