/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitQuickListContentProvider
implements VcsQuickListContentProvider {
    public List<AnAction> getVcsActions(@Nullable Project project, @Nullable AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null || !"Git".equals(activeVcs.getName())) {
            return null;
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new Separator(activeVcs.getDisplayName()));
        GitQuickListContentProvider.add("CheckinProject", manager, actions);
        GitQuickListContentProvider.add("CheckinFiles", manager, actions);
        GitQuickListContentProvider.add("ChangesView.Revert", manager, actions);
        GitQuickListContentProvider.addSeparator(actions);
        GitQuickListContentProvider.add("Vcs.ShowTabbedFileHistory", manager, actions);
        GitQuickListContentProvider.add("Annotate", manager, actions);
        GitQuickListContentProvider.add("Compare.SameVersion", manager, actions);
        GitQuickListContentProvider.addSeparator(actions);
        GitQuickListContentProvider.add("Git.Branches", manager, actions);
        GitQuickListContentProvider.add("Git.Push", manager, actions);
        GitQuickListContentProvider.add("Git.Stash", manager, actions);
        GitQuickListContentProvider.add("Git.Unstash", manager, actions);
        GitQuickListContentProvider.add("ChangesView.AddUnversioned", manager, actions);
        GitQuickListContentProvider.add("Git.ResolveConflicts", manager, actions);
        GitQuickListContentProvider.addSeparator(actions);
        AnAction githubRebase = manager.getAction("Github.Rebase");
        if (githubRebase != null) {
            actions.add((AnAction)new Separator(GitBundle.message("vcs.popup.git.github.section", new Object[0])));
            actions.add(githubRebase);
        }
        return actions;
    }

    public List<AnAction> getNotInVcsActions(@Nullable Project project, @Nullable DataContext dataContext) {
        AnAction action = ActionManager.getInstance().getAction("Git.Init");
        return Collections.singletonList(action);
    }

    public boolean replaceVcsActionsFor(@NotNull AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitQuickListContentProvider", "replaceVcsActionsFor"));
        }
        return "Git".equals(activeVcs.getName());
    }

    private static void addSeparator(@NotNull List<AnAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitQuickListContentProvider", "addSeparator"));
        }
        actions.add((AnAction)new Separator());
    }

    private static void add(String actionName, ActionManager manager, List<AnAction> actions) {
        AnAction action = manager.getAction(actionName);
        assert (action != null);
        actions.add(action);
    }
}

