/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitMerge
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("merge.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitMerge", "getActionName"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitMerge", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/actions/GitMerge", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/actions/GitMerge", "perform"));
        }
        GitVcs vcs = GitVcs.getInstance(project);
        if (vcs == null) {
            return;
        }
        GitMergeDialog dialog = new GitMergeDialog(project, gitRoots, defaultRoot);
        try {
            dialog.updateBranches();
        }
        catch (VcsException e) {
            if (vcs.getExecutableValidator().checkExecutableAndShowMessageIfNeeded(null)) {
                vcs.showErrors(Collections.singletonList(e), GitBundle.getString("merge.retrieving.branches"));
            }
            return;
        }
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, "Before update");
        GitLineHandler h = dialog.handler();
        VirtualFile root = dialog.getSelectedRoot();
        affectedRoots.add(root);
        GitRevisionNumber currentRev = GitRevisionNumber.resolve(project, root, "HEAD");
        try {
            GitHandlerUtil.doSynchronously(h, GitBundle.message("merging.title", dialog.getSelectedRoot().getPath()), h.printableCommandLine());
        }
        finally {
            exceptions.addAll(h.errors());
            GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
            manager.updateRepository(root);
        }
        if (exceptions.size() != 0) {
            return;
        }
        GitMergeUtil.showUpdates(this, project, exceptions, root, currentRev, beforeLabel, this.getActionName(), ActionInfo.INTEGRATE);
    }
}

