/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import git4idea.GitVcs;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class GitLogSingleCommitAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GitLogSingleCommitAction.class);

    protected abstract void actionPerformed(@NotNull GitRepository var1, @NotNull VcsFullCommitDetails var2);

    public void actionPerformed(AnActionEvent e) {
        Data data = Data.collect(e);
        if (!data.isValid()) {
            return;
        }
        List details = data.log.getSelectedDetails();
        if (details.size() != 1) {
            return;
        }
        VcsFullCommitDetails commit = (VcsFullCommitDetails)details.get(0);
        GitRepositoryManager repositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)data.project, GitRepositoryManager.class));
        GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(commit.getRoot());
        if (repository == null) {
            DvcsUtil.noVcsRepositoryForRoot((Logger)LOG, (VirtualFile)commit.getRoot(), (Project)data.project, (RepositoryManager)repositoryManager, (AbstractVcs)GitVcs.getInstance(data.project));
            return;
        }
        this.actionPerformed(repository, commit);
    }

    public void update(AnActionEvent e) {
        Data data = Data.collect(e);
        boolean enabled = data.isValid() && data.log.getSelectedCommits().size() == 1;
        e.getPresentation().setVisible(data.isValid());
        e.getPresentation().setEnabled(enabled);
    }

    private static class Data {
        Project project;
        VcsLog log;

        private Data() {
        }

        static Data collect(AnActionEvent e) {
            Data data = new Data();
            data.project = (Project)e.getData(CommonDataKeys.PROJECT);
            data.log = (VcsLog)e.getData(VcsLogDataKeys.VSC_LOG);
            return data;
        }

        boolean isValid() {
            return this.project != null && this.log != null && DvcsUtil.logHasRootForVcs((VcsLog)this.log, (VcsKey)GitVcs.getKey());
        }
    }
}

