/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.actions.GitLogSingleCommitAction;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GitCreateNewBranchAction
extends GitLogSingleCommitAction {
    @Override
    protected void actionPerformed(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitCreateNewBranchAction", "actionPerformed"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/actions/GitCreateNewBranchAction", "actionPerformed"));
        }
        Project project = repository.getProject();
        String reference = commit.getHash().asString();
        String name = GitBranchUtil.getNewBranchNameFromUser(project, Collections.singleton(repository), "Checkout New Branch From " + reference);
        if (name != null) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)project, GitBrancher.class);
            brancher.checkoutNewBranchStartingFrom(name, reference, Collections.singletonList(repository), null);
        }
    }
}

