/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import git4idea.GitBranch;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitDiffFromHistoryHandler;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class GitCompareWithBranchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)GitCompareWithBranchAction.class.getName());

    public void actionPerformed(AnActionEvent event) {
        String head;
        Project project = event.getProject();
        assert (project != null);
        VirtualFile file = GitCompareWithBranchAction.getAffectedFile(event);
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)manager.getRepositoryForFile(file);
        assert (repository != null);
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            String currentRevision = repository.getCurrentRevision();
            LOG.assertTrue(currentRevision != null, (Object)("Current revision is null for " + repository + ". Compare with branch shouldn't be available for fresh repository"));
            head = GitUtil.getShortHash(currentRevision);
        } else {
            head = currentBranch.getName();
        }
        List<String> branchNames = GitCompareWithBranchAction.getBranchNamesExceptCurrent(repository);
        JBList list = new JBList(branchNames);
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select branch to compare").setItemChoosenCallback((Runnable)new OnBranchChooseRunnable(project, file, head, list)).setAutoselectOnMouseMove(true).createPopup().showInBestPositionFor(event.getDataContext());
    }

    private static List<String> getBranchNamesExceptCurrent(GitRepository repository) {
        ArrayList<GitLocalBranch> localBranches = new ArrayList<GitLocalBranch>(repository.getBranches().getLocalBranches());
        Collections.sort(localBranches);
        ArrayList<GitRemoteBranch> remoteBranches = new ArrayList<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        Collections.sort(remoteBranches);
        if (repository.isOnBranch()) {
            localBranches.remove(repository.getCurrentBranch());
        }
        ArrayList<String> branchNames = new ArrayList<String>();
        for (GitBranch gitBranch : localBranches) {
            branchNames.add(gitBranch.getName());
        }
        for (GitBranch gitBranch : remoteBranches) {
            branchNames.add(gitBranch.getName());
        }
        return branchNames;
    }

    private static VirtualFile getAffectedFile(AnActionEvent event) {
        Object[] vFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null && vFiles.length == 1 && vFiles[0] != null) : "Illegal virtual files selected: " + Arrays.toString(vFiles);
        return vFiles[0];
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (vFiles == null || vFiles.length != 1 || vFiles[0] == null) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)manager.getRepositoryForFile(vFiles[0]);
        if (repository == null || repository.isFresh() || GitCompareWithBranchAction.noBranchesToCompare(repository)) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }

    private static boolean noBranchesToCompare(@NotNull GitRepository repository) {
        boolean haveRemotes;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitCompareWithBranchAction", "noBranchesToCompare"));
        }
        int locals = repository.getBranches().getLocalBranches().size();
        boolean bl = haveRemotes = !repository.getBranches().getRemoteBranches().isEmpty();
        if (repository.isOnBranch()) {
            return locals < 2 && !haveRemotes;
        }
        return locals == 0 && !haveRemotes;
    }

    private static class OnBranchChooseRunnable
    implements Runnable {
        private final Project myProject;
        private final VirtualFile myFile;
        private final String myHead;
        private final JBList myList;

        public OnBranchChooseRunnable(Project project, VirtualFile file, String head, JBList list) {
            this.myProject = project;
            this.myFile = file;
            this.myHead = head;
            this.myList = list;
        }

        @Override
        public void run() {
            String branchToCompare = this.myList.getSelectedValue().toString();
            try {
                OnBranchChooseRunnable.showDiffWithBranch(this.myProject, this.myFile, this.myHead, branchToCompare);
            }
            catch (VcsException e) {
                if (e.getMessage().contains("exists on disk, but not in")) {
                    OnBranchChooseRunnable.fileDoesntExistInBranchError(this.myProject, this.myFile, branchToCompare);
                }
                GitUIUtil.notifyError(this.myProject, "Couldn't compare with branch", String.format("Couldn't compare file [%s] with selected branch [%s]", this.myFile, this.myList.getSelectedValue()), false, (Exception)((Object)e));
            }
        }

        private static void showDiffWithBranch(@NotNull Project project, @NotNull VirtualFile file, @NotNull String head, @NotNull String branchToCompare) throws VcsException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitCompareWithBranchAction$OnBranchChooseRunnable", "showDiffWithBranch"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/actions/GitCompareWithBranchAction$OnBranchChooseRunnable", "showDiffWithBranch"));
            }
            if (head == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/actions/GitCompareWithBranchAction$OnBranchChooseRunnable", "showDiffWithBranch"));
            }
            if (branchToCompare == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/actions/GitCompareWithBranchAction$OnBranchChooseRunnable", "showDiffWithBranch"));
            }
            FilePathImpl filePath = new FilePathImpl(file);
            GitRevisionNumber currentRevisionNumber = (GitRevisionNumber)GitHistoryUtils.getCurrentRevision(project, (FilePath)filePath, head);
            GitRevisionNumber compareRevisionNumber = (GitRevisionNumber)GitHistoryUtils.getCurrentRevision(project, (FilePath)filePath, branchToCompare);
            if (compareRevisionNumber == null) {
                OnBranchChooseRunnable.fileDoesntExistInBranchError(project, file, branchToCompare);
                return;
            }
            LOG.assertTrue(currentRevisionNumber != null, (Object)String.format("Current revision number is null for file [%s] and branch [%s]", filePath, head));
            GitFileRevision compareRevision = new GitFileRevision(project, (FilePath)filePath, new GitRevisionNumber(branchToCompare, compareRevisionNumber.getTimestamp()));
            CurrentRevision currentRevision = new CurrentRevision(file, (VcsRevisionNumber)new GitRevisionNumber(head, currentRevisionNumber.getTimestamp()));
            new GitDiffFromHistoryHandler(project).showDiffForTwo((FilePath)new FilePathImpl(file), (VcsFileRevision)compareRevision, (VcsFileRevision)currentRevision);
        }

        private static void fileDoesntExistInBranchError(@NotNull Project project, @NotNull VirtualFile file, @NotNull String branchToCompare) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/actions/GitCompareWithBranchAction$OnBranchChooseRunnable", "fileDoesntExistInBranchError"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/actions/GitCompareWithBranchAction$OnBranchChooseRunnable", "fileDoesntExistInBranchError"));
            }
            if (branchToCompare == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/actions/GitCompareWithBranchAction$OnBranchChooseRunnable", "fileDoesntExistInBranchError"));
            }
            GitUIUtil.notifyMessage(project, GitUtil.fileOrFolder(file) + " doesn't exist in branch", String.format("%s <code>%s</code> doesn't exist in branch <code>%s</code>", GitUtil.fileOrFolder(file), file.getPresentableUrl(), branchToCompare), false, null);
        }
    }
}

