/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionDvcsSpecific;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileRevision
extends VcsFileRevisionEx
implements Comparable<VcsFileRevision>,
VcsFileRevisionDvcsSpecific {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final GitRevisionNumber myRevision;
    @Nullable
    private final Pair<Pair<String, String>, Pair<String, String>> myAuthorAndCommitter;
    @Nullable
    private final String myMessage;
    @Nullable
    private final String myBranch;
    @Nullable
    private final Date myAuthorTime;
    @NotNull
    private final Collection<String> myParents;

    public GitFileRevision(@NotNull Project project, @NotNull FilePath path, @NotNull GitRevisionNumber revision) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/GitFileRevision", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/GitFileRevision", "<init>"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/GitFileRevision", "<init>"));
        }
        this(project, path, revision, null, null, null, null, Collections.emptyList());
    }

    public GitFileRevision(@NotNull Project project, @NotNull FilePath path, @NotNull GitRevisionNumber revision, @Nullable Pair<Pair<String, String>, Pair<String, String>> authorAndCommitter, @Nullable String message, @Nullable String branch, @Nullable Date authorTime, @NotNull Collection<String> parents) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/GitFileRevision", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/GitFileRevision", "<init>"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/GitFileRevision", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "git4idea/GitFileRevision", "<init>"));
        }
        this.myProject = project;
        this.myPath = path;
        this.myRevision = revision;
        this.myAuthorAndCommitter = authorAndCommitter;
        this.myMessage = message;
        this.myBranch = branch;
        this.myAuthorTime = authorTime;
        this.myParents = parents;
    }

    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitFileRevision", "getPath"));
        }
        return filePath;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision;
    }

    public Date getRevisionDate() {
        return this.myRevision.getTimestamp();
    }

    @Nullable
    public Date getDateForRevisionsOrdering() {
        return this.myAuthorTime;
    }

    @Nullable
    public String getAuthor() {
        if (this.myAuthorAndCommitter != null) {
            return (String)((Pair)this.myAuthorAndCommitter.getFirst()).getFirst();
        }
        return null;
    }

    @Nullable
    public String getAuthorEmail() {
        if (this.myAuthorAndCommitter != null) {
            return (String)((Pair)this.myAuthorAndCommitter.getFirst()).getSecond();
        }
        return null;
    }

    @Nullable
    public String getCommitterName() {
        if (this.myAuthorAndCommitter != null) {
            return this.myAuthorAndCommitter.getSecond() == null ? null : (String)((Pair)this.myAuthorAndCommitter.getSecond()).getFirst();
        }
        return null;
    }

    @Nullable
    public String getCommitterEmail() {
        if (this.myAuthorAndCommitter != null) {
            return this.myAuthorAndCommitter.getSecond() == null ? null : (String)((Pair)this.myAuthorAndCommitter.getSecond()).getSecond();
        }
        return null;
    }

    @Nullable
    public String getCommitMessage() {
        return this.myMessage;
    }

    @Nullable
    public String getBranchName() {
        return this.myBranch;
    }

    public synchronized byte[] loadContent() throws IOException, VcsException {
        VirtualFile root = GitUtil.getGitRoot(this.myPath);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myPath));
    }

    public synchronized byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    @Override
    public int compareTo(VcsFileRevision rev) {
        if (rev instanceof GitFileRevision) {
            return this.myRevision.compareTo((VcsRevisionNumber)((GitFileRevision)rev).myRevision);
        }
        return this.getRevisionDate().compareTo(rev.getRevisionDate());
    }

    public String toString() {
        return this.myPath.getName() + ":" + this.myRevision.getShortRev();
    }

    @NotNull
    public Collection<String> getParents() {
        Collection<String> collection = this.myParents;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitFileRevision", "getParents"));
        }
        return collection;
    }

    @NotNull
    public String getHash() {
        String string = this.myRevision.getRev();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitFileRevision", "getHash"));
        }
        return string;
    }
}

