/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitDeprecatedRemote {
    private final String myName;
    private final String myFetchUrl;
    private final String myPushUrl;
    @NonNls
    private static final String SHOW_URL_PREFIX = "  URL: ";
    @NonNls
    private static final String SHOW_FETCH_URL_PREFIX = "  Fetch URL: ";
    @NonNls
    private static final String SHOW_PUSH_URL_PREFIX = "  Push  URL: ";
    @NonNls
    private static final String SHOW_MAPPING_PREFIX = "  Remote branch merged with 'git pull' while on branch ";
    @NonNls
    private static final String SHOW_BRANCHES_LINE = "  Tracked remote branch";
    private static final Pattern PULL_PATTERN = Pattern.compile("(\\S+)\\s+merges with remote (\\S+)");

    public GitDeprecatedRemote(@NotNull String name, String url) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/GitDeprecatedRemote", "<init>"));
        }
        this(name, url, url);
    }

    public GitDeprecatedRemote(String name, String fetchUrl, String pushUrl) {
        this.myName = name;
        this.myFetchUrl = fetchUrl;
        this.myPushUrl = pushUrl;
    }

    public String name() {
        return this.myName;
    }

    public String fetchUrl() {
        return this.myFetchUrl;
    }

    public String pushUrl() {
        return this.myPushUrl;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GitDeprecatedRemote && this.myName.equals(((GitDeprecatedRemote)obj).myName);
    }

    public String toString() {
        return this.myName;
    }

    public static List<GitDeprecatedRemote> list(Project project, VirtualFile root) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.REMOTE);
        handler.setSilent(true);
        handler.addParameters("-v");
        String output = handler.run();
        return GitDeprecatedRemote.parseRemoteListInternal(output);
    }

    public static List<GitDeprecatedRemote> parseRemoteListInternal(String output) {
        ArrayList<GitDeprecatedRemote> remotes = new ArrayList<GitDeprecatedRemote>();
        StringScanner s = new StringScanner(output);
        String name = null;
        String fetch = null;
        String push = null;
        while (s.hasMoreData()) {
            String n = s.tabToken();
            if (name != null && !n.equals(name) && fetch != null) {
                if (push == null) {
                    push = fetch;
                }
                remotes.add(new GitDeprecatedRemote(name, fetch, push));
                fetch = null;
                push = null;
            }
            name = n;
            String url = s.line();
            if (url.endsWith(" (push)")) {
                push = url.substring(0, url.length() - " (push)".length());
                continue;
            }
            if (url.endsWith(" (fetch)")) {
                fetch = url.substring(0, url.length() - " (fetch)".length());
                continue;
            }
            fetch = url;
            push = url;
        }
        if (name != null && fetch != null) {
            if (push == null) {
                push = fetch;
            }
            remotes.add(new GitDeprecatedRemote(name, fetch, push));
        }
        return remotes;
    }

    public static GitDeprecatedRemote parseRemoteInternal(String name, String output) {
        StringScanner in = new StringScanner(output);
        if (!in.tryConsume("* ")) {
            throw new IllegalStateException(GitDeprecatedRemote.unexpectedFormat(name, output));
        }
        String nameLine = in.line();
        if (!nameLine.endsWith(name)) {
            throw new IllegalStateException("Name line of 'git remote show' ends with wrong name: " + nameLine);
        }
        String fetch = null;
        String push = null;
        if (in.tryConsume(SHOW_URL_PREFIX)) {
            push = fetch = in.line();
        } else if (in.tryConsume(SHOW_FETCH_URL_PREFIX)) {
            fetch = in.line();
            push = in.tryConsume(SHOW_PUSH_URL_PREFIX) ? in.line() : fetch;
        } else {
            throw new IllegalStateException(GitDeprecatedRemote.unexpectedFormat(name, output));
        }
        return new GitDeprecatedRemote(name, fetch, push);
    }

    private static String unexpectedFormat(String remoteName, String output) {
        return String.format("Unexpected format for 'git remote show'. Remote: %s, output:%n%s", remoteName, output);
    }

    public Info parseInfoInternal(String output) {
        TreeMap<String, String> mapping = new TreeMap<String, String>();
        TreeSet<String> branches = new TreeSet<String>();
        StringScanner s = new StringScanner(output);
        if (s.tryConsume("* ") && !s.line().endsWith(this.myName)) {
            throw new IllegalStateException("Unexpected format for 'git remote show'" + output);
        }
        if (!s.hasMoreData()) {
            throw new IllegalStateException("Premature end from 'git remote show'" + output);
        }
        do {
            if (s.tryConsume(SHOW_MAPPING_PREFIX)) {
                String local = s.line();
                String remote = s.line().trim();
                mapping.put(local, remote);
                continue;
            }
            if (s.tryConsume(SHOW_BRANCHES_LINE)) {
                s.line();
                if (!s.tryConsume("    ")) continue;
                ContainerUtil.addAll(branches, (Object[])s.line().split(" "));
                continue;
            }
            if (s.tryConsume("  Remote branch")) {
                s.line();
                while (s.tryConsume("    ")) {
                    branches.add(s.line().trim());
                }
            } else if (s.tryConsume("  Local branch configured for 'git pull':")) {
                s.line();
                while (s.tryConsume("    ")) {
                    Matcher m = PULL_PATTERN.matcher(s.line());
                    if (!m.matches()) continue;
                    String local = m.group(1);
                    String remote = m.group(2);
                    mapping.put(local, remote);
                }
            } else {
                s.line();
            }
        } while (s.hasMoreData());
        return new Info(Collections.unmodifiableSortedMap(mapping), Collections.unmodifiableSortedSet(branches));
    }

    public static List<String> getFetchSpecs(Project project, VirtualFile root, String remoteName) throws VcsException {
        ArrayList<String> rc = new ArrayList<String>();
        File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
        File remotesFile = new File(rootFile, ".git" + File.separator + "remotes" + File.separator + remoteName);
        if (remotesFile.exists() && !remotesFile.isDirectory()) {
            try {
                String text = FileUtil.loadFile((File)remotesFile, (String)IOUtil.US_ASCII.name());
                String pullPrefix = "Pull:";
                StringScanner s = new StringScanner(text);
                while (s.hasMoreData()) {
                    String line = s.line();
                    if (!line.startsWith(pullPrefix)) continue;
                    rc.add(line.substring(pullPrefix.length()).trim());
                }
            }
            catch (IOException e) {
                throw new VcsException("Unable to read remotes file: " + remotesFile, (Throwable)e);
            }
        } else {
            for (Pair<String, String> pair : GitConfigUtil.getAllValues(project, root, "remote." + remoteName + ".fetch")) {
                rc.add((String)pair.second);
            }
        }
        return rc;
    }

    public class Info {
        private final Map<String, String> myBranchMapping;
        private final Set<String> myTrackedRemotes;

        public Info(Map<String, String> branchMapping, Set<String> trackedRemotes) {
            this.myBranchMapping = branchMapping;
            this.myTrackedRemotes = trackedRemotes;
        }

        public GitDeprecatedRemote remote() {
            return GitDeprecatedRemote.this;
        }

        @Nullable
        public String getRemoteForLocal(String localBranchName) {
            if (localBranchName == null) {
                return null;
            }
            return this.myBranchMapping.get(localBranchName);
        }

        public Set<String> trackedBranches() {
            return this.myTrackedRemotes;
        }
    }
}

