/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpectedExceptionNeverThrownTestNGInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/theoryinpractice/testng/inspection/ExpectedExceptionNeverThrownTestNGInspection", "buildVisitor"));
        }
        ExpectedExceptionNeverThrownVisitor expectedExceptionNeverThrownVisitor = new ExpectedExceptionNeverThrownVisitor(holder);
        if (expectedExceptionNeverThrownVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ExpectedExceptionNeverThrownTestNGInspection", "buildVisitor"));
        }
        return expectedExceptionNeverThrownVisitor;
    }

    private static class ExpectedExceptionNeverThrownVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        public ExpectedExceptionNeverThrownVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.testng.annotations.Test"});
            if (annotation == null) {
                return;
            }
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("expectedExceptions");
            if (!(value instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)value;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiType type = operand.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException")) {
                return;
            }
            List exceptionsThrown = ExceptionUtil.getThrownExceptions((PsiElement)body);
            for (PsiClassType psiClassType : exceptionsThrown) {
                if (!psiClassType.isAssignableFrom((PsiType)classType)) continue;
                return;
            }
            this.myProblemsHolder.registerProblem((PsiElement)operand, "Expected <code>#ref</code> never thrown in body of '" + method.getName() + "()' #loc", new LocalQuickFix[0]);
        }
    }
}

