/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import icons.TestngIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class TestNGConfigurationType
implements ConfigurationType {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            LOGGER.info("Create TestNG Template Configuration");
            return new TestNGConfiguration("", project, (ConfigurationFactory)this);
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/theoryinpractice/testng/configuration/TestNGConfigurationType$1", "onNewConfigurationCreated"));
            }
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }
    };

    public static TestNGConfigurationType getInstance() {
        return (TestNGConfigurationType)ConfigurationTypeUtil.findConfigurationType(TestNGConfigurationType.class);
    }

    public boolean isConfigurationByLocation(RunConfiguration runConfiguration, Location location) {
        TestNGConfiguration config = (TestNGConfiguration)runConfiguration;
        TestData testobject = config.getPersistantData();
        if (testobject == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (testobject.isConfiguredByElement(element)) {
            Module configurationModule = ((JavaRunConfigurationModule)config.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            Module predefinedModule = ((JavaRunConfigurationModule)((TestNGConfiguration)((RunManagerImpl)RunManagerEx.getInstanceEx((Project)location.getProject())).getConfigurationTemplate(this.myFactory).getConfiguration()).getConfigurationModule()).getModule();
            return Comparing.equal((Object)predefinedModule, (Object)configurationModule);
        }
        return false;
    }

    public String getDisplayName() {
        return "TestNG";
    }

    public String getConfigurationTypeDescription() {
        return "TestNG Configuration";
    }

    public Icon getIcon() {
        return TestngIcons.TestNG;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGConfigurationType", "getId"));
        }
        return "TestNG";
    }
}

